package zio.aws.backup.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.backup.model.primitives.{
  FrameworkName,
  Timestamp,
  FrameworkDescription,
  Integer,
  ARN
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Framework(
    frameworkName: Optional[FrameworkName] = Optional.Absent,
    frameworkArn: Optional[ARN] = Optional.Absent,
    frameworkDescription: Optional[FrameworkDescription] = Optional.Absent,
    numberOfControls: Optional[Integer] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    deploymentStatus: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.Framework = {
    import Framework.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.Framework
      .builder()
      .optionallyWith(
        frameworkName.map(value =>
          FrameworkName.unwrap(value): java.lang.String
        )
      )(_.frameworkName)
      .optionallyWith(
        frameworkArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.frameworkArn)
      .optionallyWith(
        frameworkDescription.map(value =>
          FrameworkDescription.unwrap(value): java.lang.String
        )
      )(_.frameworkDescription)
      .optionallyWith(numberOfControls.map(value => value: java.lang.Integer))(
        _.numberOfControls
      )
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(deploymentStatus.map(value => value: java.lang.String))(
        _.deploymentStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.Framework.ReadOnly =
    zio.aws.backup.model.Framework.wrap(buildAwsValue())
}
object Framework {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.backup.model.Framework] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.Framework =
      zio.aws.backup.model.Framework(
        frameworkName.map(value => value),
        frameworkArn.map(value => value),
        frameworkDescription.map(value => value),
        numberOfControls.map(value => value),
        creationTime.map(value => value),
        deploymentStatus.map(value => value)
      )
    def frameworkName: Optional[FrameworkName]
    def frameworkArn: Optional[ARN]
    def frameworkDescription: Optional[FrameworkDescription]
    def numberOfControls: Optional[Integer]
    def creationTime: Optional[Timestamp]
    def deploymentStatus: Optional[String]
    def getFrameworkName: ZIO[Any, AwsError, FrameworkName] =
      AwsError.unwrapOptionField("frameworkName", frameworkName)
    def getFrameworkArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("frameworkArn", frameworkArn)
    def getFrameworkDescription: ZIO[Any, AwsError, FrameworkDescription] =
      AwsError.unwrapOptionField("frameworkDescription", frameworkDescription)
    def getNumberOfControls: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("numberOfControls", numberOfControls)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getDeploymentStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deploymentStatus", deploymentStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.Framework
  ) extends zio.aws.backup.model.Framework.ReadOnly {
    override val frameworkName: Optional[FrameworkName] = zio.aws.core.internal
      .optionalFromNullable(impl.frameworkName())
      .map(value => zio.aws.backup.model.primitives.FrameworkName(value))
    override val frameworkArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.frameworkArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val frameworkDescription: Optional[FrameworkDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.frameworkDescription())
        .map(value =>
          zio.aws.backup.model.primitives.FrameworkDescription(value)
        )
    override val numberOfControls: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.numberOfControls())
      .map(value => value: Integer)
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val deploymentStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.deploymentStatus())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.Framework
  ): zio.aws.backup.model.Framework.ReadOnly = new Wrapper(impl)
}
