package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetBackupPlanRequest(
    backupPlanId: String,
    versionId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.GetBackupPlanRequest = {
    import GetBackupPlanRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.GetBackupPlanRequest
      .builder()
      .backupPlanId(backupPlanId: java.lang.String)
      .optionallyWith(versionId.map(value => value: java.lang.String))(
        _.versionId
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.GetBackupPlanRequest.ReadOnly =
    zio.aws.backup.model.GetBackupPlanRequest.wrap(buildAwsValue())
}
object GetBackupPlanRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.GetBackupPlanRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.GetBackupPlanRequest =
      zio.aws.backup.model
        .GetBackupPlanRequest(backupPlanId, versionId.map(value => value))
    def backupPlanId: String
    def versionId: Optional[String]
    def getBackupPlanId: ZIO[Any, Nothing, String] = ZIO.succeed(backupPlanId)
    def getVersionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("versionId", versionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.GetBackupPlanRequest
  ) extends zio.aws.backup.model.GetBackupPlanRequest.ReadOnly {
    override val backupPlanId: String = impl.backupPlanId(): String
    override val versionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.versionId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.GetBackupPlanRequest
  ): zio.aws.backup.model.GetBackupPlanRequest.ReadOnly = new Wrapper(impl)
}
