package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetBackupSelectionRequest(
    backupPlanId: String,
    selectionId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.GetBackupSelectionRequest = {
    import GetBackupSelectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.GetBackupSelectionRequest
      .builder()
      .backupPlanId(backupPlanId: java.lang.String)
      .selectionId(selectionId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.GetBackupSelectionRequest.ReadOnly =
    zio.aws.backup.model.GetBackupSelectionRequest.wrap(buildAwsValue())
}
object GetBackupSelectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.GetBackupSelectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.GetBackupSelectionRequest =
      zio.aws.backup.model.GetBackupSelectionRequest(backupPlanId, selectionId)
    def backupPlanId: String
    def selectionId: String
    def getBackupPlanId: ZIO[Any, Nothing, String] = ZIO.succeed(backupPlanId)
    def getSelectionId: ZIO[Any, Nothing, String] = ZIO.succeed(selectionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.GetBackupSelectionRequest
  ) extends zio.aws.backup.model.GetBackupSelectionRequest.ReadOnly {
    override val backupPlanId: String = impl.backupPlanId(): String
    override val selectionId: String = impl.selectionId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.GetBackupSelectionRequest
  ): zio.aws.backup.model.GetBackupSelectionRequest.ReadOnly = new Wrapper(impl)
}
