package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.backup.model.primitives.BackupVaultName
import scala.jdk.CollectionConverters._
final case class GetBackupVaultAccessPolicyRequest(
    backupVaultName: BackupVaultName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.GetBackupVaultAccessPolicyRequest = {
    import GetBackupVaultAccessPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.GetBackupVaultAccessPolicyRequest
      .builder()
      .backupVaultName(
        BackupVaultName.unwrap(backupVaultName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.backup.model.GetBackupVaultAccessPolicyRequest.ReadOnly =
    zio.aws.backup.model.GetBackupVaultAccessPolicyRequest.wrap(buildAwsValue())
}
object GetBackupVaultAccessPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.GetBackupVaultAccessPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.GetBackupVaultAccessPolicyRequest =
      zio.aws.backup.model.GetBackupVaultAccessPolicyRequest(backupVaultName)
    def backupVaultName: BackupVaultName
    def getBackupVaultName: ZIO[Any, Nothing, BackupVaultName] =
      ZIO.succeed(backupVaultName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.GetBackupVaultAccessPolicyRequest
  ) extends zio.aws.backup.model.GetBackupVaultAccessPolicyRequest.ReadOnly {
    override val backupVaultName: BackupVaultName =
      zio.aws.backup.model.primitives.BackupVaultName(impl.backupVaultName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.GetBackupVaultAccessPolicyRequest
  ): zio.aws.backup.model.GetBackupVaultAccessPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
