package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListBackupJobsResponse(
    backupJobs: Optional[Iterable[zio.aws.backup.model.BackupJob]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ListBackupJobsResponse = {
    import ListBackupJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ListBackupJobsResponse
      .builder()
      .optionallyWith(
        backupJobs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.backupJobs)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.ListBackupJobsResponse.ReadOnly =
    zio.aws.backup.model.ListBackupJobsResponse.wrap(buildAwsValue())
}
object ListBackupJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ListBackupJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ListBackupJobsResponse =
      zio.aws.backup.model.ListBackupJobsResponse(
        backupJobs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def backupJobs: Optional[List[zio.aws.backup.model.BackupJob.ReadOnly]]
    def nextToken: Optional[String]
    def getBackupJobs
        : ZIO[Any, AwsError, List[zio.aws.backup.model.BackupJob.ReadOnly]] =
      AwsError.unwrapOptionField("backupJobs", backupJobs)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ListBackupJobsResponse
  ) extends zio.aws.backup.model.ListBackupJobsResponse.ReadOnly {
    override val backupJobs
        : Optional[List[zio.aws.backup.model.BackupJob.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupJobs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.backup.model.BackupJob.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ListBackupJobsResponse
  ): zio.aws.backup.model.ListBackupJobsResponse.ReadOnly = new Wrapper(impl)
}
