package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListBackupPlanTemplatesResponse(
    nextToken: Optional[String] = Optional.Absent,
    backupPlanTemplatesList: Optional[
      Iterable[zio.aws.backup.model.BackupPlanTemplatesListMember]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesResponse = {
    import ListBackupPlanTemplatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        backupPlanTemplatesList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.backupPlanTemplatesList)
      .build()
  }
  def asReadOnly
      : zio.aws.backup.model.ListBackupPlanTemplatesResponse.ReadOnly =
    zio.aws.backup.model.ListBackupPlanTemplatesResponse.wrap(buildAwsValue())
}
object ListBackupPlanTemplatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ListBackupPlanTemplatesResponse =
      zio.aws.backup.model.ListBackupPlanTemplatesResponse(
        nextToken.map(value => value),
        backupPlanTemplatesList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def backupPlanTemplatesList: Optional[
      List[zio.aws.backup.model.BackupPlanTemplatesListMember.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getBackupPlanTemplatesList: ZIO[Any, AwsError, List[
      zio.aws.backup.model.BackupPlanTemplatesListMember.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "backupPlanTemplatesList",
      backupPlanTemplatesList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesResponse
  ) extends zio.aws.backup.model.ListBackupPlanTemplatesResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val backupPlanTemplatesList: Optional[
      List[zio.aws.backup.model.BackupPlanTemplatesListMember.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.backupPlanTemplatesList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.backup.model.BackupPlanTemplatesListMember.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesResponse
  ): zio.aws.backup.model.ListBackupPlanTemplatesResponse.ReadOnly =
    new Wrapper(impl)
}
