package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListBackupPlansResponse(
    nextToken: Optional[String] = Optional.Absent,
    backupPlansList: Optional[
      Iterable[zio.aws.backup.model.BackupPlansListMember]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ListBackupPlansResponse = {
    import ListBackupPlansResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ListBackupPlansResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        backupPlansList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.backupPlansList)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.ListBackupPlansResponse.ReadOnly =
    zio.aws.backup.model.ListBackupPlansResponse.wrap(buildAwsValue())
}
object ListBackupPlansResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ListBackupPlansResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ListBackupPlansResponse =
      zio.aws.backup.model.ListBackupPlansResponse(
        nextToken.map(value => value),
        backupPlansList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def backupPlansList
        : Optional[List[zio.aws.backup.model.BackupPlansListMember.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getBackupPlansList: ZIO[Any, AwsError, List[
      zio.aws.backup.model.BackupPlansListMember.ReadOnly
    ]] = AwsError.unwrapOptionField("backupPlansList", backupPlansList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ListBackupPlansResponse
  ) extends zio.aws.backup.model.ListBackupPlansResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val backupPlansList
        : Optional[List[zio.aws.backup.model.BackupPlansListMember.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupPlansList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.backup.model.BackupPlansListMember.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ListBackupPlansResponse
  ): zio.aws.backup.model.ListBackupPlansResponse.ReadOnly = new Wrapper(impl)
}
