package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListReportJobsResponse(
    reportJobs: Optional[Iterable[zio.aws.backup.model.ReportJob]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ListReportJobsResponse = {
    import ListReportJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ListReportJobsResponse
      .builder()
      .optionallyWith(
        reportJobs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reportJobs)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.ListReportJobsResponse.ReadOnly =
    zio.aws.backup.model.ListReportJobsResponse.wrap(buildAwsValue())
}
object ListReportJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ListReportJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ListReportJobsResponse =
      zio.aws.backup.model.ListReportJobsResponse(
        reportJobs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def reportJobs: Optional[List[zio.aws.backup.model.ReportJob.ReadOnly]]
    def nextToken: Optional[String]
    def getReportJobs
        : ZIO[Any, AwsError, List[zio.aws.backup.model.ReportJob.ReadOnly]] =
      AwsError.unwrapOptionField("reportJobs", reportJobs)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ListReportJobsResponse
  ) extends zio.aws.backup.model.ListReportJobsResponse.ReadOnly {
    override val reportJobs
        : Optional[List[zio.aws.backup.model.ReportJob.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reportJobs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.backup.model.ReportJob.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ListReportJobsResponse
  ): zio.aws.backup.model.ListReportJobsResponse.ReadOnly = new Wrapper(impl)
}
