package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReportDestination(
    s3BucketName: Optional[String] = Optional.Absent,
    s3Keys: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ReportDestination = {
    import ReportDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ReportDestination
      .builder()
      .optionallyWith(s3BucketName.map(value => value: java.lang.String))(
        _.s3BucketName
      )
      .optionallyWith(
        s3Keys.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.s3Keys)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.ReportDestination.ReadOnly =
    zio.aws.backup.model.ReportDestination.wrap(buildAwsValue())
}
object ReportDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ReportDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ReportDestination =
      zio.aws.backup.model.ReportDestination(
        s3BucketName.map(value => value),
        s3Keys.map(value => value)
      )
    def s3BucketName: Optional[String]
    def s3Keys: Optional[List[String]]
    def getS3BucketName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3BucketName", s3BucketName)
    def getS3Keys: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("s3Keys", s3Keys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ReportDestination
  ) extends zio.aws.backup.model.ReportDestination.ReadOnly {
    override val s3BucketName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.s3BucketName())
      .map(value => value: String)
    override val s3Keys: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Keys())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ReportDestination
  ): zio.aws.backup.model.ReportDestination.ReadOnly = new Wrapper(impl)
}
