package zio.aws.backup.model
import scala.jdk.CollectionConverters._
sealed trait RestoreJobStatus {
  def unwrap: software.amazon.awssdk.services.backup.model.RestoreJobStatus
}
object RestoreJobStatus {
  def wrap(
      value: software.amazon.awssdk.services.backup.model.RestoreJobStatus
  ): zio.aws.backup.model.RestoreJobStatus = value match {
    case software.amazon.awssdk.services.backup.model.RestoreJobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.backup.model.RestoreJobStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.backup.model.RestoreJobStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.backup.model.RestoreJobStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.backup.model.RestoreJobStatus.ABORTED =>
      val r = ABORTED
      r
    case software.amazon.awssdk.services.backup.model.RestoreJobStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.backup.model.RestoreJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.RestoreJobStatus =
      software.amazon.awssdk.services.backup.model.RestoreJobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.backup.model.RestoreJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.RestoreJobStatus =
      software.amazon.awssdk.services.backup.model.RestoreJobStatus.PENDING
  }
  case object RUNNING extends zio.aws.backup.model.RestoreJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.RestoreJobStatus =
      software.amazon.awssdk.services.backup.model.RestoreJobStatus.RUNNING
  }
  case object COMPLETED extends zio.aws.backup.model.RestoreJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.RestoreJobStatus =
      software.amazon.awssdk.services.backup.model.RestoreJobStatus.COMPLETED
  }
  case object ABORTED extends zio.aws.backup.model.RestoreJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.RestoreJobStatus =
      software.amazon.awssdk.services.backup.model.RestoreJobStatus.ABORTED
  }
  case object FAILED extends zio.aws.backup.model.RestoreJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.RestoreJobStatus =
      software.amazon.awssdk.services.backup.model.RestoreJobStatus.FAILED
  }
}
