package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{
  IAMRoleArn,
  BackupVaultName,
  TagValue,
  WindowMinutes,
  BackupOptionKey,
  BackupOptionValue,
  ARN,
  TagKey
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartBackupJobRequest(
    backupVaultName: BackupVaultName,
    resourceArn: ARN,
    iamRoleArn: IAMRoleArn,
    idempotencyToken: Optional[String] = Optional.Absent,
    startWindowMinutes: Optional[WindowMinutes] = Optional.Absent,
    completeWindowMinutes: Optional[WindowMinutes] = Optional.Absent,
    lifecycle: Optional[zio.aws.backup.model.Lifecycle] = Optional.Absent,
    recoveryPointTags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    backupOptions: Optional[Map[BackupOptionKey, BackupOptionValue]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.StartBackupJobRequest = {
    import StartBackupJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.StartBackupJobRequest
      .builder()
      .backupVaultName(
        BackupVaultName.unwrap(backupVaultName): java.lang.String
      )
      .resourceArn(ARN.unwrap(resourceArn): java.lang.String)
      .iamRoleArn(IAMRoleArn.unwrap(iamRoleArn): java.lang.String)
      .optionallyWith(idempotencyToken.map(value => value: java.lang.String))(
        _.idempotencyToken
      )
      .optionallyWith(
        startWindowMinutes.map(value =>
          WindowMinutes.unwrap(value): java.lang.Long
        )
      )(_.startWindowMinutes)
      .optionallyWith(
        completeWindowMinutes.map(value =>
          WindowMinutes.unwrap(value): java.lang.Long
        )
      )(_.completeWindowMinutes)
      .optionallyWith(lifecycle.map(value => value.buildAwsValue()))(
        _.lifecycle
      )
      .optionallyWith(
        recoveryPointTags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.recoveryPointTags)
      .optionallyWith(
        backupOptions.map(value =>
          value
            .map({ case (key, value) =>
              (BackupOptionKey
                .unwrap(key): java.lang.String) -> (BackupOptionValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.backupOptions)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.StartBackupJobRequest.ReadOnly =
    zio.aws.backup.model.StartBackupJobRequest.wrap(buildAwsValue())
}
object StartBackupJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.StartBackupJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.StartBackupJobRequest =
      zio.aws.backup.model.StartBackupJobRequest(
        backupVaultName,
        resourceArn,
        iamRoleArn,
        idempotencyToken.map(value => value),
        startWindowMinutes.map(value => value),
        completeWindowMinutes.map(value => value),
        lifecycle.map(value => value.asEditable),
        recoveryPointTags.map(value => value),
        backupOptions.map(value => value)
      )
    def backupVaultName: BackupVaultName
    def resourceArn: ARN
    def iamRoleArn: IAMRoleArn
    def idempotencyToken: Optional[String]
    def startWindowMinutes: Optional[WindowMinutes]
    def completeWindowMinutes: Optional[WindowMinutes]
    def lifecycle: Optional[zio.aws.backup.model.Lifecycle.ReadOnly]
    def recoveryPointTags: Optional[Map[TagKey, TagValue]]
    def backupOptions: Optional[Map[BackupOptionKey, BackupOptionValue]]
    def getBackupVaultName: ZIO[Any, Nothing, BackupVaultName] =
      ZIO.succeed(backupVaultName)
    def getResourceArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(resourceArn)
    def getIamRoleArn: ZIO[Any, Nothing, IAMRoleArn] = ZIO.succeed(iamRoleArn)
    def getIdempotencyToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("idempotencyToken", idempotencyToken)
    def getStartWindowMinutes: ZIO[Any, AwsError, WindowMinutes] =
      AwsError.unwrapOptionField("startWindowMinutes", startWindowMinutes)
    def getCompleteWindowMinutes: ZIO[Any, AwsError, WindowMinutes] =
      AwsError.unwrapOptionField("completeWindowMinutes", completeWindowMinutes)
    def getLifecycle
        : ZIO[Any, AwsError, zio.aws.backup.model.Lifecycle.ReadOnly] =
      AwsError.unwrapOptionField("lifecycle", lifecycle)
    def getRecoveryPointTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("recoveryPointTags", recoveryPointTags)
    def getBackupOptions
        : ZIO[Any, AwsError, Map[BackupOptionKey, BackupOptionValue]] =
      AwsError.unwrapOptionField("backupOptions", backupOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.StartBackupJobRequest
  ) extends zio.aws.backup.model.StartBackupJobRequest.ReadOnly {
    override val backupVaultName: BackupVaultName =
      zio.aws.backup.model.primitives.BackupVaultName(impl.backupVaultName())
    override val resourceArn: ARN =
      zio.aws.backup.model.primitives.ARN(impl.resourceArn())
    override val iamRoleArn: IAMRoleArn =
      zio.aws.backup.model.primitives.IAMRoleArn(impl.iamRoleArn())
    override val idempotencyToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.idempotencyToken())
      .map(value => value: String)
    override val startWindowMinutes: Optional[WindowMinutes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startWindowMinutes())
        .map(value => zio.aws.backup.model.primitives.WindowMinutes(value))
    override val completeWindowMinutes: Optional[WindowMinutes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.completeWindowMinutes())
        .map(value => zio.aws.backup.model.primitives.WindowMinutes(value))
    override val lifecycle: Optional[zio.aws.backup.model.Lifecycle.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecycle())
        .map(value => zio.aws.backup.model.Lifecycle.wrap(value))
    override val recoveryPointTags: Optional[Map[TagKey, TagValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recoveryPointTags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.backup.model.primitives
                .TagKey(key) -> zio.aws.backup.model.primitives.TagValue(value)
            })
            .toMap
        )
    override val backupOptions
        : Optional[Map[BackupOptionKey, BackupOptionValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupOptions())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.backup.model.primitives.BackupOptionKey(
                key
              ) -> zio.aws.backup.model.primitives.BackupOptionValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.StartBackupJobRequest
  ): zio.aws.backup.model.StartBackupJobRequest.ReadOnly = new Wrapper(impl)
}
