package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{IAMRoleArn, BackupVaultName, ARN}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartCopyJobRequest(
    recoveryPointArn: ARN,
    sourceBackupVaultName: BackupVaultName,
    destinationBackupVaultArn: ARN,
    iamRoleArn: IAMRoleArn,
    idempotencyToken: Optional[String] = Optional.Absent,
    lifecycle: Optional[zio.aws.backup.model.Lifecycle] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.StartCopyJobRequest = {
    import StartCopyJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.StartCopyJobRequest
      .builder()
      .recoveryPointArn(ARN.unwrap(recoveryPointArn): java.lang.String)
      .sourceBackupVaultName(
        BackupVaultName.unwrap(sourceBackupVaultName): java.lang.String
      )
      .destinationBackupVaultArn(
        ARN.unwrap(destinationBackupVaultArn): java.lang.String
      )
      .iamRoleArn(IAMRoleArn.unwrap(iamRoleArn): java.lang.String)
      .optionallyWith(idempotencyToken.map(value => value: java.lang.String))(
        _.idempotencyToken
      )
      .optionallyWith(lifecycle.map(value => value.buildAwsValue()))(
        _.lifecycle
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.StartCopyJobRequest.ReadOnly =
    zio.aws.backup.model.StartCopyJobRequest.wrap(buildAwsValue())
}
object StartCopyJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.StartCopyJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.StartCopyJobRequest =
      zio.aws.backup.model.StartCopyJobRequest(
        recoveryPointArn,
        sourceBackupVaultName,
        destinationBackupVaultArn,
        iamRoleArn,
        idempotencyToken.map(value => value),
        lifecycle.map(value => value.asEditable)
      )
    def recoveryPointArn: ARN
    def sourceBackupVaultName: BackupVaultName
    def destinationBackupVaultArn: ARN
    def iamRoleArn: IAMRoleArn
    def idempotencyToken: Optional[String]
    def lifecycle: Optional[zio.aws.backup.model.Lifecycle.ReadOnly]
    def getRecoveryPointArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(recoveryPointArn)
    def getSourceBackupVaultName: ZIO[Any, Nothing, BackupVaultName] =
      ZIO.succeed(sourceBackupVaultName)
    def getDestinationBackupVaultArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(destinationBackupVaultArn)
    def getIamRoleArn: ZIO[Any, Nothing, IAMRoleArn] = ZIO.succeed(iamRoleArn)
    def getIdempotencyToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("idempotencyToken", idempotencyToken)
    def getLifecycle
        : ZIO[Any, AwsError, zio.aws.backup.model.Lifecycle.ReadOnly] =
      AwsError.unwrapOptionField("lifecycle", lifecycle)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.StartCopyJobRequest
  ) extends zio.aws.backup.model.StartCopyJobRequest.ReadOnly {
    override val recoveryPointArn: ARN =
      zio.aws.backup.model.primitives.ARN(impl.recoveryPointArn())
    override val sourceBackupVaultName: BackupVaultName =
      zio.aws.backup.model.primitives
        .BackupVaultName(impl.sourceBackupVaultName())
    override val destinationBackupVaultArn: ARN =
      zio.aws.backup.model.primitives.ARN(impl.destinationBackupVaultArn())
    override val iamRoleArn: IAMRoleArn =
      zio.aws.backup.model.primitives.IAMRoleArn(impl.iamRoleArn())
    override val idempotencyToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.idempotencyToken())
      .map(value => value: String)
    override val lifecycle: Optional[zio.aws.backup.model.Lifecycle.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecycle())
        .map(value => zio.aws.backup.model.Lifecycle.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.StartCopyJobRequest
  ): zio.aws.backup.model.StartCopyJobRequest.ReadOnly = new Wrapper(impl)
}
