package zio.aws.backup.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.backup.model.primitives.Timestamp
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class StartCopyJobResponse(
    copyJobId: Optional[String] = Optional.Absent,
    creationDate: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.StartCopyJobResponse = {
    import StartCopyJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.StartCopyJobResponse
      .builder()
      .optionallyWith(copyJobId.map(value => value: java.lang.String))(
        _.copyJobId
      )
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.StartCopyJobResponse.ReadOnly =
    zio.aws.backup.model.StartCopyJobResponse.wrap(buildAwsValue())
}
object StartCopyJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.StartCopyJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.StartCopyJobResponse =
      zio.aws.backup.model.StartCopyJobResponse(
        copyJobId.map(value => value),
        creationDate.map(value => value)
      )
    def copyJobId: Optional[String]
    def creationDate: Optional[Timestamp]
    def getCopyJobId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("copyJobId", copyJobId)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.StartCopyJobResponse
  ) extends zio.aws.backup.model.StartCopyJobResponse.ReadOnly {
    override val copyJobId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.copyJobId())
      .map(value => value: String)
    override val creationDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.StartCopyJobResponse
  ): zio.aws.backup.model.StartCopyJobResponse.ReadOnly = new Wrapper(impl)
}
