package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AttemptDetail(
    container: Optional[zio.aws.batch.model.AttemptContainerDetail] =
      Optional.Absent,
    startedAt: Optional[Long] = Optional.Absent,
    stoppedAt: Optional[Long] = Optional.Absent,
    statusReason: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.AttemptDetail = {
    import AttemptDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.AttemptDetail
      .builder()
      .optionallyWith(container.map(value => value.buildAwsValue()))(
        _.container
      )
      .optionallyWith(startedAt.map(value => value: java.lang.Long))(
        _.startedAt
      )
      .optionallyWith(stoppedAt.map(value => value: java.lang.Long))(
        _.stoppedAt
      )
      .optionallyWith(statusReason.map(value => value: java.lang.String))(
        _.statusReason
      )
      .build()
  }
  def asReadOnly: zio.aws.batch.model.AttemptDetail.ReadOnly =
    zio.aws.batch.model.AttemptDetail.wrap(buildAwsValue())
}
object AttemptDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.AttemptDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.AttemptDetail =
      zio.aws.batch.model.AttemptDetail(
        container.map(value => value.asEditable),
        startedAt.map(value => value),
        stoppedAt.map(value => value),
        statusReason.map(value => value)
      )
    def container: Optional[zio.aws.batch.model.AttemptContainerDetail.ReadOnly]
    def startedAt: Optional[Long]
    def stoppedAt: Optional[Long]
    def statusReason: Optional[String]
    def getContainer: ZIO[
      Any,
      AwsError,
      zio.aws.batch.model.AttemptContainerDetail.ReadOnly
    ] = AwsError.unwrapOptionField("container", container)
    def getStartedAt: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("startedAt", startedAt)
    def getStoppedAt: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("stoppedAt", stoppedAt)
    def getStatusReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusReason", statusReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.AttemptDetail
  ) extends zio.aws.batch.model.AttemptDetail.ReadOnly {
    override val container
        : Optional[zio.aws.batch.model.AttemptContainerDetail.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.container())
        .map(value => zio.aws.batch.model.AttemptContainerDetail.wrap(value))
    override val startedAt: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.startedAt())
      .map(value => value: Long)
    override val stoppedAt: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.stoppedAt())
      .map(value => value: Long)
    override val statusReason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusReason())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.AttemptDetail
  ): zio.aws.batch.model.AttemptDetail.ReadOnly = new Wrapper(impl)
}
