package zio.aws.batch.model
import scala.jdk.CollectionConverters._
sealed trait CRAllocationStrategy {
  def unwrap: software.amazon.awssdk.services.batch.model.CRAllocationStrategy
}
object CRAllocationStrategy {
  def wrap(
      value: software.amazon.awssdk.services.batch.model.CRAllocationStrategy
  ): zio.aws.batch.model.CRAllocationStrategy = value match {
    case software.amazon.awssdk.services.batch.model.CRAllocationStrategy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.batch.model.CRAllocationStrategy.BEST_FIT =>
      val r = BEST_FIT
      r
    case software.amazon.awssdk.services.batch.model.CRAllocationStrategy.BEST_FIT_PROGRESSIVE =>
      val r = BEST_FIT_PROGRESSIVE
      r
    case software.amazon.awssdk.services.batch.model.CRAllocationStrategy.SPOT_CAPACITY_OPTIMIZED =>
      val r = SPOT_CAPACITY_OPTIMIZED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.batch.model.CRAllocationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.batch.model.CRAllocationStrategy =
      software.amazon.awssdk.services.batch.model.CRAllocationStrategy.UNKNOWN_TO_SDK_VERSION
  }
  case object BEST_FIT extends zio.aws.batch.model.CRAllocationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.batch.model.CRAllocationStrategy =
      software.amazon.awssdk.services.batch.model.CRAllocationStrategy.BEST_FIT
  }
  case object BEST_FIT_PROGRESSIVE
      extends zio.aws.batch.model.CRAllocationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.batch.model.CRAllocationStrategy =
      software.amazon.awssdk.services.batch.model.CRAllocationStrategy.BEST_FIT_PROGRESSIVE
  }
  case object SPOT_CAPACITY_OPTIMIZED
      extends zio.aws.batch.model.CRAllocationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.batch.model.CRAllocationStrategy =
      software.amazon.awssdk.services.batch.model.CRAllocationStrategy.SPOT_CAPACITY_OPTIMIZED
  }
}
