package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ComputeResource(
    `type`: zio.aws.batch.model.CRType,
    allocationStrategy: Optional[zio.aws.batch.model.CRAllocationStrategy] =
      Optional.Absent,
    minvCpus: Optional[Integer] = Optional.Absent,
    maxvCpus: Integer,
    desiredvCpus: Optional[Integer] = Optional.Absent,
    instanceTypes: Optional[Iterable[String]] = Optional.Absent,
    imageId: Optional[String] = Optional.Absent,
    subnets: Iterable[String],
    securityGroupIds: Optional[Iterable[String]] = Optional.Absent,
    ec2KeyPair: Optional[String] = Optional.Absent,
    instanceRole: Optional[String] = Optional.Absent,
    tags: Optional[Map[String, String]] = Optional.Absent,
    placementGroup: Optional[String] = Optional.Absent,
    bidPercentage: Optional[Integer] = Optional.Absent,
    spotIamFleetRole: Optional[String] = Optional.Absent,
    launchTemplate: Optional[zio.aws.batch.model.LaunchTemplateSpecification] =
      Optional.Absent,
    ec2Configuration: Optional[Iterable[zio.aws.batch.model.Ec2Configuration]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.ComputeResource = {
    import ComputeResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.ComputeResource
      .builder()
      .`type`(`type`.unwrap)
      .optionallyWith(allocationStrategy.map(value => value.unwrap))(
        _.allocationStrategy
      )
      .optionallyWith(minvCpus.map(value => value: java.lang.Integer))(
        _.minvCpus
      )
      .maxvCpus(maxvCpus: java.lang.Integer)
      .optionallyWith(desiredvCpus.map(value => value: java.lang.Integer))(
        _.desiredvCpus
      )
      .optionallyWith(
        instanceTypes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.instanceTypes)
      .optionallyWith(imageId.map(value => value: java.lang.String))(_.imageId)
      .subnets(subnets.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(ec2KeyPair.map(value => value: java.lang.String))(
        _.ec2KeyPair
      )
      .optionallyWith(instanceRole.map(value => value: java.lang.String))(
        _.instanceRole
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(placementGroup.map(value => value: java.lang.String))(
        _.placementGroup
      )
      .optionallyWith(bidPercentage.map(value => value: java.lang.Integer))(
        _.bidPercentage
      )
      .optionallyWith(spotIamFleetRole.map(value => value: java.lang.String))(
        _.spotIamFleetRole
      )
      .optionallyWith(launchTemplate.map(value => value.buildAwsValue()))(
        _.launchTemplate
      )
      .optionallyWith(
        ec2Configuration.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ec2Configuration)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.ComputeResource.ReadOnly =
    zio.aws.batch.model.ComputeResource.wrap(buildAwsValue())
}
object ComputeResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.ComputeResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.ComputeResource =
      zio.aws.batch.model.ComputeResource(
        `type`,
        allocationStrategy.map(value => value),
        minvCpus.map(value => value),
        maxvCpus,
        desiredvCpus.map(value => value),
        instanceTypes.map(value => value),
        imageId.map(value => value),
        subnets,
        securityGroupIds.map(value => value),
        ec2KeyPair.map(value => value),
        instanceRole.map(value => value),
        tags.map(value => value),
        placementGroup.map(value => value),
        bidPercentage.map(value => value),
        spotIamFleetRole.map(value => value),
        launchTemplate.map(value => value.asEditable),
        ec2Configuration.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def `type`: zio.aws.batch.model.CRType
    def allocationStrategy: Optional[zio.aws.batch.model.CRAllocationStrategy]
    def minvCpus: Optional[Integer]
    def maxvCpus: Integer
    def desiredvCpus: Optional[Integer]
    def instanceTypes: Optional[List[String]]
    def imageId: Optional[String]
    def subnets: List[String]
    def securityGroupIds: Optional[List[String]]
    def ec2KeyPair: Optional[String]
    def instanceRole: Optional[String]
    def tags: Optional[Map[String, String]]
    def placementGroup: Optional[String]
    def bidPercentage: Optional[Integer]
    def spotIamFleetRole: Optional[String]
    def launchTemplate
        : Optional[zio.aws.batch.model.LaunchTemplateSpecification.ReadOnly]
    def ec2Configuration
        : Optional[List[zio.aws.batch.model.Ec2Configuration.ReadOnly]]
    def getType: ZIO[Any, Nothing, zio.aws.batch.model.CRType] =
      ZIO.succeed(`type`)
    def getAllocationStrategy
        : ZIO[Any, AwsError, zio.aws.batch.model.CRAllocationStrategy] =
      AwsError.unwrapOptionField("allocationStrategy", allocationStrategy)
    def getMinvCpus: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("minvCpus", minvCpus)
    def getMaxvCpus: ZIO[Any, Nothing, Integer] = ZIO.succeed(maxvCpus)
    def getDesiredvCpus: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("desiredvCpus", desiredvCpus)
    def getInstanceTypes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("instanceTypes", instanceTypes)
    def getImageId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getSubnets: ZIO[Any, Nothing, List[String]] = ZIO.succeed(subnets)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getEc2KeyPair: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ec2KeyPair", ec2KeyPair)
    def getInstanceRole: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceRole", instanceRole)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
    def getPlacementGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("placementGroup", placementGroup)
    def getBidPercentage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("bidPercentage", bidPercentage)
    def getSpotIamFleetRole: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("spotIamFleetRole", spotIamFleetRole)
    def getLaunchTemplate: ZIO[
      Any,
      AwsError,
      zio.aws.batch.model.LaunchTemplateSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("launchTemplate", launchTemplate)
    def getEc2Configuration: ZIO[Any, AwsError, List[
      zio.aws.batch.model.Ec2Configuration.ReadOnly
    ]] = AwsError.unwrapOptionField("ec2Configuration", ec2Configuration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.ComputeResource
  ) extends zio.aws.batch.model.ComputeResource.ReadOnly {
    override val `type`: zio.aws.batch.model.CRType =
      zio.aws.batch.model.CRType.wrap(impl.`type`())
    override val allocationStrategy
        : Optional[zio.aws.batch.model.CRAllocationStrategy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allocationStrategy())
        .map(value => zio.aws.batch.model.CRAllocationStrategy.wrap(value))
    override val minvCpus: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.minvCpus())
      .map(value => value: Integer)
    override val maxvCpus: Integer = impl.maxvCpus(): Integer
    override val desiredvCpus: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.desiredvCpus())
      .map(value => value: Integer)
    override val instanceTypes: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceTypes())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val imageId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.imageId())
      .map(value => value: String)
    override val subnets: List[String] = impl
      .subnets()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val securityGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val ec2KeyPair: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ec2KeyPair())
      .map(value => value: String)
    override val instanceRole: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceRole())
      .map(value => value: String)
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val placementGroup: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.placementGroup())
      .map(value => value: String)
    override val bidPercentage: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.bidPercentage())
      .map(value => value: Integer)
    override val spotIamFleetRole: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.spotIamFleetRole())
      .map(value => value: String)
    override val launchTemplate
        : Optional[zio.aws.batch.model.LaunchTemplateSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchTemplate())
        .map(value =>
          zio.aws.batch.model.LaunchTemplateSpecification.wrap(value)
        )
    override val ec2Configuration
        : Optional[List[zio.aws.batch.model.Ec2Configuration.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ec2Configuration())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.batch.model.Ec2Configuration.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.ComputeResource
  ): zio.aws.batch.model.ComputeResource.ReadOnly = new Wrapper(impl)
}
