package zio.aws.batch.model
import zio.aws.batch.model.primitives.{TagValue, TagKey, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateComputeEnvironmentRequest(
    computeEnvironmentName: String,
    `type`: zio.aws.batch.model.CEType,
    state: Optional[zio.aws.batch.model.CEState] = Optional.Absent,
    unmanagedvCpus: Optional[Integer] = Optional.Absent,
    computeResources: Optional[zio.aws.batch.model.ComputeResource] =
      Optional.Absent,
    serviceRole: Optional[String] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.CreateComputeEnvironmentRequest = {
    import CreateComputeEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.CreateComputeEnvironmentRequest
      .builder()
      .computeEnvironmentName(computeEnvironmentName: java.lang.String)
      .`type`(`type`.unwrap)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(unmanagedvCpus.map(value => value: java.lang.Integer))(
        _.unmanagedvCpus
      )
      .optionallyWith(computeResources.map(value => value.buildAwsValue()))(
        _.computeResources
      )
      .optionallyWith(serviceRole.map(value => value: java.lang.String))(
        _.serviceRole
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.CreateComputeEnvironmentRequest.ReadOnly =
    zio.aws.batch.model.CreateComputeEnvironmentRequest.wrap(buildAwsValue())
}
object CreateComputeEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.CreateComputeEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.CreateComputeEnvironmentRequest =
      zio.aws.batch.model.CreateComputeEnvironmentRequest(
        computeEnvironmentName,
        `type`,
        state.map(value => value),
        unmanagedvCpus.map(value => value),
        computeResources.map(value => value.asEditable),
        serviceRole.map(value => value),
        tags.map(value => value)
      )
    def computeEnvironmentName: String
    def `type`: zio.aws.batch.model.CEType
    def state: Optional[zio.aws.batch.model.CEState]
    def unmanagedvCpus: Optional[Integer]
    def computeResources: Optional[zio.aws.batch.model.ComputeResource.ReadOnly]
    def serviceRole: Optional[String]
    def tags: Optional[Map[TagKey, TagValue]]
    def getComputeEnvironmentName: ZIO[Any, Nothing, String] =
      ZIO.succeed(computeEnvironmentName)
    def getType: ZIO[Any, Nothing, zio.aws.batch.model.CEType] =
      ZIO.succeed(`type`)
    def getState: ZIO[Any, AwsError, zio.aws.batch.model.CEState] =
      AwsError.unwrapOptionField("state", state)
    def getUnmanagedvCpus: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("unmanagedvCpus", unmanagedvCpus)
    def getComputeResources
        : ZIO[Any, AwsError, zio.aws.batch.model.ComputeResource.ReadOnly] =
      AwsError.unwrapOptionField("computeResources", computeResources)
    def getServiceRole: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceRole", serviceRole)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.CreateComputeEnvironmentRequest
  ) extends zio.aws.batch.model.CreateComputeEnvironmentRequest.ReadOnly {
    override val computeEnvironmentName: String =
      impl.computeEnvironmentName(): String
    override val `type`: zio.aws.batch.model.CEType =
      zio.aws.batch.model.CEType.wrap(impl.`type`())
    override val state: Optional[zio.aws.batch.model.CEState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.batch.model.CEState.wrap(value))
    override val unmanagedvCpus: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.unmanagedvCpus())
      .map(value => value: Integer)
    override val computeResources
        : Optional[zio.aws.batch.model.ComputeResource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.computeResources())
        .map(value => zio.aws.batch.model.ComputeResource.wrap(value))
    override val serviceRole: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceRole())
      .map(value => value: String)
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.batch.model.primitives
              .TagKey(key) -> zio.aws.batch.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.CreateComputeEnvironmentRequest
  ): zio.aws.batch.model.CreateComputeEnvironmentRequest.ReadOnly = new Wrapper(
    impl
  )
}
