package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeComputeEnvironmentsResponse(
    computeEnvironments: Optional[
      Iterable[zio.aws.batch.model.ComputeEnvironmentDetail]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.DescribeComputeEnvironmentsResponse = {
    import DescribeComputeEnvironmentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.DescribeComputeEnvironmentsResponse
      .builder()
      .optionallyWith(
        computeEnvironments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.computeEnvironments)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.batch.model.DescribeComputeEnvironmentsResponse.ReadOnly =
    zio.aws.batch.model.DescribeComputeEnvironmentsResponse
      .wrap(buildAwsValue())
}
object DescribeComputeEnvironmentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.DescribeComputeEnvironmentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.DescribeComputeEnvironmentsResponse =
      zio.aws.batch.model.DescribeComputeEnvironmentsResponse(
        computeEnvironments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def computeEnvironments
        : Optional[List[zio.aws.batch.model.ComputeEnvironmentDetail.ReadOnly]]
    def nextToken: Optional[String]
    def getComputeEnvironments: ZIO[Any, AwsError, List[
      zio.aws.batch.model.ComputeEnvironmentDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("computeEnvironments", computeEnvironments)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.DescribeComputeEnvironmentsResponse
  ) extends zio.aws.batch.model.DescribeComputeEnvironmentsResponse.ReadOnly {
    override val computeEnvironments: Optional[
      List[zio.aws.batch.model.ComputeEnvironmentDetail.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.computeEnvironments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.batch.model.ComputeEnvironmentDetail.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.DescribeComputeEnvironmentsResponse
  ): zio.aws.batch.model.DescribeComputeEnvironmentsResponse.ReadOnly =
    new Wrapper(impl)
}
