package zio.aws.batch.model
import scala.jdk.CollectionConverters._
sealed trait EFSAuthorizationConfigIAM {
  def unwrap
      : software.amazon.awssdk.services.batch.model.EFSAuthorizationConfigIAM
}
object EFSAuthorizationConfigIAM {
  def wrap(
      value: software.amazon.awssdk.services.batch.model.EFSAuthorizationConfigIAM
  ): zio.aws.batch.model.EFSAuthorizationConfigIAM = value match {
    case software.amazon.awssdk.services.batch.model.EFSAuthorizationConfigIAM.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.batch.model.EFSAuthorizationConfigIAM.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.batch.model.EFSAuthorizationConfigIAM.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.batch.model.EFSAuthorizationConfigIAM {
    override def unwrap
        : software.amazon.awssdk.services.batch.model.EFSAuthorizationConfigIAM =
      software.amazon.awssdk.services.batch.model.EFSAuthorizationConfigIAM.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.batch.model.EFSAuthorizationConfigIAM {
    override def unwrap
        : software.amazon.awssdk.services.batch.model.EFSAuthorizationConfigIAM =
      software.amazon.awssdk.services.batch.model.EFSAuthorizationConfigIAM.ENABLED
  }
  case object DISABLED extends zio.aws.batch.model.EFSAuthorizationConfigIAM {
    override def unwrap
        : software.amazon.awssdk.services.batch.model.EFSAuthorizationConfigIAM =
      software.amazon.awssdk.services.batch.model.EFSAuthorizationConfigIAM.DISABLED
  }
}
