package zio.aws.batch.model
import scala.jdk.CollectionConverters._
sealed trait EFSTransitEncryption {
  def unwrap: software.amazon.awssdk.services.batch.model.EFSTransitEncryption
}
object EFSTransitEncryption {
  def wrap(
      value: software.amazon.awssdk.services.batch.model.EFSTransitEncryption
  ): zio.aws.batch.model.EFSTransitEncryption = value match {
    case software.amazon.awssdk.services.batch.model.EFSTransitEncryption.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.batch.model.EFSTransitEncryption.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.batch.model.EFSTransitEncryption.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.batch.model.EFSTransitEncryption {
    override def unwrap
        : software.amazon.awssdk.services.batch.model.EFSTransitEncryption =
      software.amazon.awssdk.services.batch.model.EFSTransitEncryption.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.batch.model.EFSTransitEncryption {
    override def unwrap
        : software.amazon.awssdk.services.batch.model.EFSTransitEncryption =
      software.amazon.awssdk.services.batch.model.EFSTransitEncryption.ENABLED
  }
  case object DISABLED extends zio.aws.batch.model.EFSTransitEncryption {
    override def unwrap
        : software.amazon.awssdk.services.batch.model.EFSTransitEncryption =
      software.amazon.awssdk.services.batch.model.EFSTransitEncryption.DISABLED
  }
}
