package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FairsharePolicy(
    shareDecaySeconds: Optional[Integer] = Optional.Absent,
    computeReservation: Optional[Integer] = Optional.Absent,
    shareDistribution: Optional[Iterable[zio.aws.batch.model.ShareAttributes]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.FairsharePolicy = {
    import FairsharePolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.FairsharePolicy
      .builder()
      .optionallyWith(shareDecaySeconds.map(value => value: java.lang.Integer))(
        _.shareDecaySeconds
      )
      .optionallyWith(
        computeReservation.map(value => value: java.lang.Integer)
      )(_.computeReservation)
      .optionallyWith(
        shareDistribution.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.shareDistribution)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.FairsharePolicy.ReadOnly =
    zio.aws.batch.model.FairsharePolicy.wrap(buildAwsValue())
}
object FairsharePolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.FairsharePolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.FairsharePolicy =
      zio.aws.batch.model.FairsharePolicy(
        shareDecaySeconds.map(value => value),
        computeReservation.map(value => value),
        shareDistribution.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def shareDecaySeconds: Optional[Integer]
    def computeReservation: Optional[Integer]
    def shareDistribution
        : Optional[List[zio.aws.batch.model.ShareAttributes.ReadOnly]]
    def getShareDecaySeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("shareDecaySeconds", shareDecaySeconds)
    def getComputeReservation: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("computeReservation", computeReservation)
    def getShareDistribution: ZIO[Any, AwsError, List[
      zio.aws.batch.model.ShareAttributes.ReadOnly
    ]] = AwsError.unwrapOptionField("shareDistribution", shareDistribution)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.FairsharePolicy
  ) extends zio.aws.batch.model.FairsharePolicy.ReadOnly {
    override val shareDecaySeconds: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.shareDecaySeconds())
      .map(value => value: Integer)
    override val computeReservation: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.computeReservation())
      .map(value => value: Integer)
    override val shareDistribution
        : Optional[List[zio.aws.batch.model.ShareAttributes.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.shareDistribution())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.batch.model.ShareAttributes.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.FairsharePolicy
  ): zio.aws.batch.model.FairsharePolicy.ReadOnly = new Wrapper(impl)
}
