package zio.aws.batch.model
import scala.jdk.CollectionConverters._
sealed trait JQState {
  def unwrap: software.amazon.awssdk.services.batch.model.JQState
}
object JQState {
  def wrap(
      value: software.amazon.awssdk.services.batch.model.JQState
  ): zio.aws.batch.model.JQState = value match {
    case software.amazon.awssdk.services.batch.model.JQState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.batch.model.JQState.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.batch.model.JQState.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion extends zio.aws.batch.model.JQState {
    override def unwrap: software.amazon.awssdk.services.batch.model.JQState =
      software.amazon.awssdk.services.batch.model.JQState.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.batch.model.JQState {
    override def unwrap: software.amazon.awssdk.services.batch.model.JQState =
      software.amazon.awssdk.services.batch.model.JQState.ENABLED
  }
  case object DISABLED extends zio.aws.batch.model.JQState {
    override def unwrap: software.amazon.awssdk.services.batch.model.JQState =
      software.amazon.awssdk.services.batch.model.JQState.DISABLED
  }
}
