package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NodeDetails(
    nodeIndex: Optional[Integer] = Optional.Absent,
    isMainNode: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.NodeDetails = {
    import NodeDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.NodeDetails
      .builder()
      .optionallyWith(nodeIndex.map(value => value: java.lang.Integer))(
        _.nodeIndex
      )
      .optionallyWith(isMainNode.map(value => value: java.lang.Boolean))(
        _.isMainNode
      )
      .build()
  }
  def asReadOnly: zio.aws.batch.model.NodeDetails.ReadOnly =
    zio.aws.batch.model.NodeDetails.wrap(buildAwsValue())
}
object NodeDetails {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.batch.model.NodeDetails] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.NodeDetails =
      zio.aws.batch.model.NodeDetails(
        nodeIndex.map(value => value),
        isMainNode.map(value => value)
      )
    def nodeIndex: Optional[Integer]
    def isMainNode: Optional[Boolean]
    def getNodeIndex: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("nodeIndex", nodeIndex)
    def getIsMainNode: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isMainNode", isMainNode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.NodeDetails
  ) extends zio.aws.batch.model.NodeDetails.ReadOnly {
    override val nodeIndex: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeIndex())
      .map(value => value: Integer)
    override val isMainNode: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isMainNode())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.NodeDetails
  ): zio.aws.batch.model.NodeDetails.ReadOnly = new Wrapper(impl)
}
