package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NodeOverrides(
    numNodes: Optional[Integer] = Optional.Absent,
    nodePropertyOverrides: Optional[
      Iterable[zio.aws.batch.model.NodePropertyOverride]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.NodeOverrides = {
    import NodeOverrides.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.NodeOverrides
      .builder()
      .optionallyWith(numNodes.map(value => value: java.lang.Integer))(
        _.numNodes
      )
      .optionallyWith(
        nodePropertyOverrides.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.nodePropertyOverrides)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.NodeOverrides.ReadOnly =
    zio.aws.batch.model.NodeOverrides.wrap(buildAwsValue())
}
object NodeOverrides {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.NodeOverrides
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.NodeOverrides =
      zio.aws.batch.model.NodeOverrides(
        numNodes.map(value => value),
        nodePropertyOverrides.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def numNodes: Optional[Integer]
    def nodePropertyOverrides
        : Optional[List[zio.aws.batch.model.NodePropertyOverride.ReadOnly]]
    def getNumNodes: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("numNodes", numNodes)
    def getNodePropertyOverrides: ZIO[Any, AwsError, List[
      zio.aws.batch.model.NodePropertyOverride.ReadOnly
    ]] =
      AwsError.unwrapOptionField("nodePropertyOverrides", nodePropertyOverrides)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.NodeOverrides
  ) extends zio.aws.batch.model.NodeOverrides.ReadOnly {
    override val numNodes: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.numNodes())
      .map(value => value: Integer)
    override val nodePropertyOverrides
        : Optional[List[zio.aws.batch.model.NodePropertyOverride.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nodePropertyOverrides())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.batch.model.NodePropertyOverride.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.NodeOverrides
  ): zio.aws.batch.model.NodeOverrides.ReadOnly = new Wrapper(impl)
}
