package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class NodeProperties(
    numNodes: Integer,
    mainNode: Integer,
    nodeRangeProperties: Iterable[zio.aws.batch.model.NodeRangeProperty]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.NodeProperties = {
    import NodeProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.NodeProperties
      .builder()
      .numNodes(numNodes: java.lang.Integer)
      .mainNode(mainNode: java.lang.Integer)
      .nodeRangeProperties(nodeRangeProperties.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.NodeProperties.ReadOnly =
    zio.aws.batch.model.NodeProperties.wrap(buildAwsValue())
}
object NodeProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.NodeProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.NodeProperties =
      zio.aws.batch.model.NodeProperties(
        numNodes,
        mainNode,
        nodeRangeProperties.map { item =>
          item.asEditable
        }
      )
    def numNodes: Integer
    def mainNode: Integer
    def nodeRangeProperties
        : List[zio.aws.batch.model.NodeRangeProperty.ReadOnly]
    def getNumNodes: ZIO[Any, Nothing, Integer] = ZIO.succeed(numNodes)
    def getMainNode: ZIO[Any, Nothing, Integer] = ZIO.succeed(mainNode)
    def getNodeRangeProperties: ZIO[Any, Nothing, List[
      zio.aws.batch.model.NodeRangeProperty.ReadOnly
    ]] = ZIO.succeed(nodeRangeProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.NodeProperties
  ) extends zio.aws.batch.model.NodeProperties.ReadOnly {
    override val numNodes: Integer = impl.numNodes(): Integer
    override val mainNode: Integer = impl.mainNode(): Integer
    override val nodeRangeProperties
        : List[zio.aws.batch.model.NodeRangeProperty.ReadOnly] = impl
      .nodeRangeProperties()
      .asScala
      .map { item =>
        zio.aws.batch.model.NodeRangeProperty.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.NodeProperties
  ): zio.aws.batch.model.NodeProperties.ReadOnly = new Wrapper(impl)
}
