package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ShareAttributes(
    shareIdentifier: String,
    weightFactor: Optional[Float] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.ShareAttributes = {
    import ShareAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.ShareAttributes
      .builder()
      .shareIdentifier(shareIdentifier: java.lang.String)
      .optionallyWith(weightFactor.map(value => value: java.lang.Float))(
        _.weightFactor
      )
      .build()
  }
  def asReadOnly: zio.aws.batch.model.ShareAttributes.ReadOnly =
    zio.aws.batch.model.ShareAttributes.wrap(buildAwsValue())
}
object ShareAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.ShareAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.ShareAttributes = zio.aws.batch.model
      .ShareAttributes(shareIdentifier, weightFactor.map(value => value))
    def shareIdentifier: String
    def weightFactor: Optional[Float]
    def getShareIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(shareIdentifier)
    def getWeightFactor: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("weightFactor", weightFactor)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.ShareAttributes
  ) extends zio.aws.batch.model.ShareAttributes.ReadOnly {
    override val shareIdentifier: String = impl.shareIdentifier(): String
    override val weightFactor: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.weightFactor())
      .map(value => value: Float)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.ShareAttributes
  ): zio.aws.batch.model.ShareAttributes.ReadOnly = new Wrapper(impl)
}
