package zio.aws.batch.model
import zio.aws.batch.model.primitives.JobExecutionTimeoutMinutes
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdatePolicy(
    terminateJobsOnUpdate: Optional[Boolean] = Optional.Absent,
    jobExecutionTimeoutMinutes: Optional[JobExecutionTimeoutMinutes] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.UpdatePolicy = {
    import UpdatePolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.UpdatePolicy
      .builder()
      .optionallyWith(
        terminateJobsOnUpdate.map(value => value: java.lang.Boolean)
      )(_.terminateJobsOnUpdate)
      .optionallyWith(
        jobExecutionTimeoutMinutes.map(value =>
          JobExecutionTimeoutMinutes.unwrap(value): java.lang.Long
        )
      )(_.jobExecutionTimeoutMinutes)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.UpdatePolicy.ReadOnly =
    zio.aws.batch.model.UpdatePolicy.wrap(buildAwsValue())
}
object UpdatePolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.UpdatePolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.UpdatePolicy =
      zio.aws.batch.model.UpdatePolicy(
        terminateJobsOnUpdate.map(value => value),
        jobExecutionTimeoutMinutes.map(value => value)
      )
    def terminateJobsOnUpdate: Optional[Boolean]
    def jobExecutionTimeoutMinutes: Optional[JobExecutionTimeoutMinutes]
    def getTerminateJobsOnUpdate: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("terminateJobsOnUpdate", terminateJobsOnUpdate)
    def getJobExecutionTimeoutMinutes
        : ZIO[Any, AwsError, JobExecutionTimeoutMinutes] =
      AwsError.unwrapOptionField(
        "jobExecutionTimeoutMinutes",
        jobExecutionTimeoutMinutes
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.UpdatePolicy
  ) extends zio.aws.batch.model.UpdatePolicy.ReadOnly {
    override val terminateJobsOnUpdate: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.terminateJobsOnUpdate())
        .map(value => value: Boolean)
    override val jobExecutionTimeoutMinutes
        : Optional[JobExecutionTimeoutMinutes] = zio.aws.core.internal
      .optionalFromNullable(impl.jobExecutionTimeoutMinutes())
      .map(value =>
        zio.aws.batch.model.primitives.JobExecutionTimeoutMinutes(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.UpdatePolicy
  ): zio.aws.batch.model.UpdatePolicy.ReadOnly = new Wrapper(impl)
}
