package zio.aws.batch.model
import scala.jdk.CollectionConverters._
sealed trait CEStatus {
  def unwrap: software.amazon.awssdk.services.batch.model.CEStatus
}
object CEStatus {
  def wrap(
      value: software.amazon.awssdk.services.batch.model.CEStatus
  ): zio.aws.batch.model.CEStatus = value match {
    case software.amazon.awssdk.services.batch.model.CEStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.batch.model.CEStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.batch.model.CEStatus.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.batch.model.CEStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.batch.model.CEStatus.DELETED =>
      val r = DELETED
      r
    case software.amazon.awssdk.services.batch.model.CEStatus.VALID =>
      val r = VALID
      r
    case software.amazon.awssdk.services.batch.model.CEStatus.INVALID =>
      val r = INVALID
      r
  }
  case object unknownToSdkVersion extends zio.aws.batch.model.CEStatus {
    override def unwrap: software.amazon.awssdk.services.batch.model.CEStatus =
      software.amazon.awssdk.services.batch.model.CEStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.batch.model.CEStatus {
    override def unwrap: software.amazon.awssdk.services.batch.model.CEStatus =
      software.amazon.awssdk.services.batch.model.CEStatus.CREATING
  }
  case object UPDATING extends zio.aws.batch.model.CEStatus {
    override def unwrap: software.amazon.awssdk.services.batch.model.CEStatus =
      software.amazon.awssdk.services.batch.model.CEStatus.UPDATING
  }
  case object DELETING extends zio.aws.batch.model.CEStatus {
    override def unwrap: software.amazon.awssdk.services.batch.model.CEStatus =
      software.amazon.awssdk.services.batch.model.CEStatus.DELETING
  }
  case object DELETED extends zio.aws.batch.model.CEStatus {
    override def unwrap: software.amazon.awssdk.services.batch.model.CEStatus =
      software.amazon.awssdk.services.batch.model.CEStatus.DELETED
  }
  case object VALID extends zio.aws.batch.model.CEStatus {
    override def unwrap: software.amazon.awssdk.services.batch.model.CEStatus =
      software.amazon.awssdk.services.batch.model.CEStatus.VALID
  }
  case object INVALID extends zio.aws.batch.model.CEStatus {
    override def unwrap: software.amazon.awssdk.services.batch.model.CEStatus =
      software.amazon.awssdk.services.batch.model.CEStatus.INVALID
  }
}
