package zio.aws.batch.model
import scala.jdk.CollectionConverters._
sealed trait CRType {
  def unwrap: software.amazon.awssdk.services.batch.model.CRType
}
object CRType {
  def wrap(
      value: software.amazon.awssdk.services.batch.model.CRType
  ): zio.aws.batch.model.CRType = value match {
    case software.amazon.awssdk.services.batch.model.CRType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.batch.model.CRType.EC2 =>
      val r = EC2
      r
    case software.amazon.awssdk.services.batch.model.CRType.SPOT =>
      val r = SPOT
      r
    case software.amazon.awssdk.services.batch.model.CRType.FARGATE =>
      val r = FARGATE
      r
    case software.amazon.awssdk.services.batch.model.CRType.FARGATE_SPOT =>
      val r = FARGATE_SPOT
      r
  }
  case object unknownToSdkVersion extends zio.aws.batch.model.CRType {
    override def unwrap: software.amazon.awssdk.services.batch.model.CRType =
      software.amazon.awssdk.services.batch.model.CRType.UNKNOWN_TO_SDK_VERSION
  }
  case object EC2 extends zio.aws.batch.model.CRType {
    override def unwrap: software.amazon.awssdk.services.batch.model.CRType =
      software.amazon.awssdk.services.batch.model.CRType.EC2
  }
  case object SPOT extends zio.aws.batch.model.CRType {
    override def unwrap: software.amazon.awssdk.services.batch.model.CRType =
      software.amazon.awssdk.services.batch.model.CRType.SPOT
  }
  case object FARGATE extends zio.aws.batch.model.CRType {
    override def unwrap: software.amazon.awssdk.services.batch.model.CRType =
      software.amazon.awssdk.services.batch.model.CRType.FARGATE
  }
  case object FARGATE_SPOT extends zio.aws.batch.model.CRType {
    override def unwrap: software.amazon.awssdk.services.batch.model.CRType =
      software.amazon.awssdk.services.batch.model.CRType.FARGATE_SPOT
  }
}
