package zio.aws.batch.model
import zio.aws.batch.model.primitives.{TagValue, TagKey, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ComputeEnvironmentDetail(
    computeEnvironmentName: String,
    computeEnvironmentArn: String,
    unmanagedvCpus: Optional[Integer] = Optional.Absent,
    ecsClusterArn: Optional[String] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    `type`: Optional[zio.aws.batch.model.CEType] = Optional.Absent,
    state: Optional[zio.aws.batch.model.CEState] = Optional.Absent,
    status: Optional[zio.aws.batch.model.CEStatus] = Optional.Absent,
    statusReason: Optional[String] = Optional.Absent,
    computeResources: Optional[zio.aws.batch.model.ComputeResource] =
      Optional.Absent,
    serviceRole: Optional[String] = Optional.Absent,
    updatePolicy: Optional[zio.aws.batch.model.UpdatePolicy] = Optional.Absent,
    eksConfiguration: Optional[zio.aws.batch.model.EksConfiguration] =
      Optional.Absent,
    containerOrchestrationType: Optional[
      zio.aws.batch.model.OrchestrationType
    ] = Optional.Absent,
    uuid: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.ComputeEnvironmentDetail = {
    import ComputeEnvironmentDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.ComputeEnvironmentDetail
      .builder()
      .computeEnvironmentName(computeEnvironmentName: java.lang.String)
      .computeEnvironmentArn(computeEnvironmentArn: java.lang.String)
      .optionallyWith(unmanagedvCpus.map(value => value: java.lang.Integer))(
        _.unmanagedvCpus
      )
      .optionallyWith(ecsClusterArn.map(value => value: java.lang.String))(
        _.ecsClusterArn
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusReason.map(value => value: java.lang.String))(
        _.statusReason
      )
      .optionallyWith(computeResources.map(value => value.buildAwsValue()))(
        _.computeResources
      )
      .optionallyWith(serviceRole.map(value => value: java.lang.String))(
        _.serviceRole
      )
      .optionallyWith(updatePolicy.map(value => value.buildAwsValue()))(
        _.updatePolicy
      )
      .optionallyWith(eksConfiguration.map(value => value.buildAwsValue()))(
        _.eksConfiguration
      )
      .optionallyWith(containerOrchestrationType.map(value => value.unwrap))(
        _.containerOrchestrationType
      )
      .optionallyWith(uuid.map(value => value: java.lang.String))(_.uuid)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.ComputeEnvironmentDetail.ReadOnly =
    zio.aws.batch.model.ComputeEnvironmentDetail.wrap(buildAwsValue())
}
object ComputeEnvironmentDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.ComputeEnvironmentDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.ComputeEnvironmentDetail =
      zio.aws.batch.model.ComputeEnvironmentDetail(
        computeEnvironmentName,
        computeEnvironmentArn,
        unmanagedvCpus.map(value => value),
        ecsClusterArn.map(value => value),
        tags.map(value => value),
        `type`.map(value => value),
        state.map(value => value),
        status.map(value => value),
        statusReason.map(value => value),
        computeResources.map(value => value.asEditable),
        serviceRole.map(value => value),
        updatePolicy.map(value => value.asEditable),
        eksConfiguration.map(value => value.asEditable),
        containerOrchestrationType.map(value => value),
        uuid.map(value => value)
      )
    def computeEnvironmentName: String
    def computeEnvironmentArn: String
    def unmanagedvCpus: Optional[Integer]
    def ecsClusterArn: Optional[String]
    def tags: Optional[Map[TagKey, TagValue]]
    def `type`: Optional[zio.aws.batch.model.CEType]
    def state: Optional[zio.aws.batch.model.CEState]
    def status: Optional[zio.aws.batch.model.CEStatus]
    def statusReason: Optional[String]
    def computeResources: Optional[zio.aws.batch.model.ComputeResource.ReadOnly]
    def serviceRole: Optional[String]
    def updatePolicy: Optional[zio.aws.batch.model.UpdatePolicy.ReadOnly]
    def eksConfiguration
        : Optional[zio.aws.batch.model.EksConfiguration.ReadOnly]
    def containerOrchestrationType
        : Optional[zio.aws.batch.model.OrchestrationType]
    def uuid: Optional[String]
    def getComputeEnvironmentName: ZIO[Any, Nothing, String] =
      ZIO.succeed(computeEnvironmentName)
    def getComputeEnvironmentArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(computeEnvironmentArn)
    def getUnmanagedvCpus: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("unmanagedvCpus", unmanagedvCpus)
    def getEcsClusterArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ecsClusterArn", ecsClusterArn)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getType: ZIO[Any, AwsError, zio.aws.batch.model.CEType] =
      AwsError.unwrapOptionField("type", `type`)
    def getState: ZIO[Any, AwsError, zio.aws.batch.model.CEState] =
      AwsError.unwrapOptionField("state", state)
    def getStatus: ZIO[Any, AwsError, zio.aws.batch.model.CEStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getComputeResources
        : ZIO[Any, AwsError, zio.aws.batch.model.ComputeResource.ReadOnly] =
      AwsError.unwrapOptionField("computeResources", computeResources)
    def getServiceRole: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceRole", serviceRole)
    def getUpdatePolicy
        : ZIO[Any, AwsError, zio.aws.batch.model.UpdatePolicy.ReadOnly] =
      AwsError.unwrapOptionField("updatePolicy", updatePolicy)
    def getEksConfiguration
        : ZIO[Any, AwsError, zio.aws.batch.model.EksConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("eksConfiguration", eksConfiguration)
    def getContainerOrchestrationType
        : ZIO[Any, AwsError, zio.aws.batch.model.OrchestrationType] =
      AwsError.unwrapOptionField(
        "containerOrchestrationType",
        containerOrchestrationType
      )
    def getUuid: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("uuid", uuid)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.ComputeEnvironmentDetail
  ) extends zio.aws.batch.model.ComputeEnvironmentDetail.ReadOnly {
    override val computeEnvironmentName: String =
      impl.computeEnvironmentName(): String
    override val computeEnvironmentArn: String =
      impl.computeEnvironmentArn(): String
    override val unmanagedvCpus: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.unmanagedvCpus())
      .map(value => value: Integer)
    override val ecsClusterArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ecsClusterArn())
      .map(value => value: String)
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.batch.model.primitives
              .TagKey(key) -> zio.aws.batch.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val `type`: Optional[zio.aws.batch.model.CEType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.batch.model.CEType.wrap(value))
    override val state: Optional[zio.aws.batch.model.CEState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.batch.model.CEState.wrap(value))
    override val status: Optional[zio.aws.batch.model.CEStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.batch.model.CEStatus.wrap(value))
    override val statusReason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusReason())
      .map(value => value: String)
    override val computeResources
        : Optional[zio.aws.batch.model.ComputeResource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.computeResources())
        .map(value => zio.aws.batch.model.ComputeResource.wrap(value))
    override val serviceRole: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceRole())
      .map(value => value: String)
    override val updatePolicy
        : Optional[zio.aws.batch.model.UpdatePolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updatePolicy())
        .map(value => zio.aws.batch.model.UpdatePolicy.wrap(value))
    override val eksConfiguration
        : Optional[zio.aws.batch.model.EksConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eksConfiguration())
        .map(value => zio.aws.batch.model.EksConfiguration.wrap(value))
    override val containerOrchestrationType
        : Optional[zio.aws.batch.model.OrchestrationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containerOrchestrationType())
        .map(value => zio.aws.batch.model.OrchestrationType.wrap(value))
    override val uuid: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.uuid())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.ComputeEnvironmentDetail
  ): zio.aws.batch.model.ComputeEnvironmentDetail.ReadOnly = new Wrapper(impl)
}
