package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeComputeEnvironmentsRequest(
    computeEnvironments: Optional[Iterable[String]] = Optional.Absent,
    maxResults: Optional[Integer] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.DescribeComputeEnvironmentsRequest = {
    import DescribeComputeEnvironmentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.DescribeComputeEnvironmentsRequest
      .builder()
      .optionallyWith(
        computeEnvironments.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.computeEnvironments)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.batch.model.DescribeComputeEnvironmentsRequest.ReadOnly =
    zio.aws.batch.model.DescribeComputeEnvironmentsRequest.wrap(buildAwsValue())
}
object DescribeComputeEnvironmentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.DescribeComputeEnvironmentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.DescribeComputeEnvironmentsRequest =
      zio.aws.batch.model.DescribeComputeEnvironmentsRequest(
        computeEnvironments.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def computeEnvironments: Optional[List[String]]
    def maxResults: Optional[Integer]
    def nextToken: Optional[String]
    def getComputeEnvironments: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("computeEnvironments", computeEnvironments)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.DescribeComputeEnvironmentsRequest
  ) extends zio.aws.batch.model.DescribeComputeEnvironmentsRequest.ReadOnly {
    override val computeEnvironments: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.computeEnvironments())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.DescribeComputeEnvironmentsRequest
  ): zio.aws.batch.model.DescribeComputeEnvironmentsRequest.ReadOnly =
    new Wrapper(impl)
}
