package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeJobsResponse(
    jobs: Optional[Iterable[zio.aws.batch.model.JobDetail]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.DescribeJobsResponse = {
    import DescribeJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.DescribeJobsResponse
      .builder()
      .optionallyWith(
        jobs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.jobs)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.DescribeJobsResponse.ReadOnly =
    zio.aws.batch.model.DescribeJobsResponse.wrap(buildAwsValue())
}
object DescribeJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.DescribeJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.DescribeJobsResponse =
      zio.aws.batch.model.DescribeJobsResponse(
        jobs.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def jobs: Optional[List[zio.aws.batch.model.JobDetail.ReadOnly]]
    def getJobs
        : ZIO[Any, AwsError, List[zio.aws.batch.model.JobDetail.ReadOnly]] =
      AwsError.unwrapOptionField("jobs", jobs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.DescribeJobsResponse
  ) extends zio.aws.batch.model.DescribeJobsResponse.ReadOnly {
    override val jobs: Optional[List[zio.aws.batch.model.JobDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.batch.model.JobDetail.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.DescribeJobsResponse
  ): zio.aws.batch.model.DescribeJobsResponse.ReadOnly = new Wrapper(impl)
}
