package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EksAttemptContainerDetail(
    exitCode: Optional[Integer] = Optional.Absent,
    reason: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.EksAttemptContainerDetail = {
    import EksAttemptContainerDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.EksAttemptContainerDetail
      .builder()
      .optionallyWith(exitCode.map(value => value: java.lang.Integer))(
        _.exitCode
      )
      .optionallyWith(reason.map(value => value: java.lang.String))(_.reason)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.EksAttemptContainerDetail.ReadOnly =
    zio.aws.batch.model.EksAttemptContainerDetail.wrap(buildAwsValue())
}
object EksAttemptContainerDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.EksAttemptContainerDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.EksAttemptContainerDetail =
      zio.aws.batch.model.EksAttemptContainerDetail(
        exitCode.map(value => value),
        reason.map(value => value)
      )
    def exitCode: Optional[Integer]
    def reason: Optional[String]
    def getExitCode: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("exitCode", exitCode)
    def getReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reason", reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.EksAttemptContainerDetail
  ) extends zio.aws.batch.model.EksAttemptContainerDetail.ReadOnly {
    override val exitCode: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.exitCode())
      .map(value => value: Integer)
    override val reason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.EksAttemptContainerDetail
  ): zio.aws.batch.model.EksAttemptContainerDetail.ReadOnly = new Wrapper(impl)
}
