package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EksAttemptDetail(
    containers: Optional[
      Iterable[zio.aws.batch.model.EksAttemptContainerDetail]
    ] = Optional.Absent,
    podName: Optional[String] = Optional.Absent,
    nodeName: Optional[String] = Optional.Absent,
    startedAt: Optional[Long] = Optional.Absent,
    stoppedAt: Optional[Long] = Optional.Absent,
    statusReason: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.EksAttemptDetail = {
    import EksAttemptDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.EksAttemptDetail
      .builder()
      .optionallyWith(
        containers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.containers)
      .optionallyWith(podName.map(value => value: java.lang.String))(_.podName)
      .optionallyWith(nodeName.map(value => value: java.lang.String))(
        _.nodeName
      )
      .optionallyWith(startedAt.map(value => value: java.lang.Long))(
        _.startedAt
      )
      .optionallyWith(stoppedAt.map(value => value: java.lang.Long))(
        _.stoppedAt
      )
      .optionallyWith(statusReason.map(value => value: java.lang.String))(
        _.statusReason
      )
      .build()
  }
  def asReadOnly: zio.aws.batch.model.EksAttemptDetail.ReadOnly =
    zio.aws.batch.model.EksAttemptDetail.wrap(buildAwsValue())
}
object EksAttemptDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.EksAttemptDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.EksAttemptDetail =
      zio.aws.batch.model.EksAttemptDetail(
        containers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        podName.map(value => value),
        nodeName.map(value => value),
        startedAt.map(value => value),
        stoppedAt.map(value => value),
        statusReason.map(value => value)
      )
    def containers
        : Optional[List[zio.aws.batch.model.EksAttemptContainerDetail.ReadOnly]]
    def podName: Optional[String]
    def nodeName: Optional[String]
    def startedAt: Optional[Long]
    def stoppedAt: Optional[Long]
    def statusReason: Optional[String]
    def getContainers: ZIO[Any, AwsError, List[
      zio.aws.batch.model.EksAttemptContainerDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("containers", containers)
    def getPodName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("podName", podName)
    def getNodeName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeName", nodeName)
    def getStartedAt: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("startedAt", startedAt)
    def getStoppedAt: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("stoppedAt", stoppedAt)
    def getStatusReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusReason", statusReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.EksAttemptDetail
  ) extends zio.aws.batch.model.EksAttemptDetail.ReadOnly {
    override val containers: Optional[
      List[zio.aws.batch.model.EksAttemptContainerDetail.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.containers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.batch.model.EksAttemptContainerDetail.wrap(item)
        }.toList
      )
    override val podName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.podName())
      .map(value => value: String)
    override val nodeName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeName())
      .map(value => value: String)
    override val startedAt: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.startedAt())
      .map(value => value: Long)
    override val stoppedAt: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.stoppedAt())
      .map(value => value: Long)
    override val statusReason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusReason())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.EksAttemptDetail
  ): zio.aws.batch.model.EksAttemptDetail.ReadOnly = new Wrapper(impl)
}
