package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EksContainerEnvironmentVariable(
    name: String,
    value: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.EksContainerEnvironmentVariable = {
    import EksContainerEnvironmentVariable.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.EksContainerEnvironmentVariable
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.EksContainerEnvironmentVariable.ReadOnly =
    zio.aws.batch.model.EksContainerEnvironmentVariable.wrap(buildAwsValue())
}
object EksContainerEnvironmentVariable {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.EksContainerEnvironmentVariable
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.EksContainerEnvironmentVariable =
      zio.aws.batch.model
        .EksContainerEnvironmentVariable(name, value.map(value => value))
    def name: String
    def value: Optional[String]
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.EksContainerEnvironmentVariable
  ) extends zio.aws.batch.model.EksContainerEnvironmentVariable.ReadOnly {
    override val name: String = impl.name(): String
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.EksContainerEnvironmentVariable
  ): zio.aws.batch.model.EksContainerEnvironmentVariable.ReadOnly = new Wrapper(
    impl
  )
}
