package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EksContainerOverride(
    image: Optional[String] = Optional.Absent,
    command: Optional[Iterable[String]] = Optional.Absent,
    args: Optional[Iterable[String]] = Optional.Absent,
    env: Optional[
      Iterable[zio.aws.batch.model.EksContainerEnvironmentVariable]
    ] = Optional.Absent,
    resources: Optional[zio.aws.batch.model.EksContainerResourceRequirements] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.EksContainerOverride = {
    import EksContainerOverride.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.EksContainerOverride
      .builder()
      .optionallyWith(image.map(value => value: java.lang.String))(_.image)
      .optionallyWith(
        command.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.command)
      .optionallyWith(
        args.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.args)
      .optionallyWith(
        env.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.env)
      .optionallyWith(resources.map(value => value.buildAwsValue()))(
        _.resources
      )
      .build()
  }
  def asReadOnly: zio.aws.batch.model.EksContainerOverride.ReadOnly =
    zio.aws.batch.model.EksContainerOverride.wrap(buildAwsValue())
}
object EksContainerOverride {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.EksContainerOverride
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.EksContainerOverride =
      zio.aws.batch.model.EksContainerOverride(
        image.map(value => value),
        command.map(value => value),
        args.map(value => value),
        env.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resources.map(value => value.asEditable)
      )
    def image: Optional[String]
    def command: Optional[List[String]]
    def args: Optional[List[String]]
    def env: Optional[
      List[zio.aws.batch.model.EksContainerEnvironmentVariable.ReadOnly]
    ]
    def resources: Optional[
      zio.aws.batch.model.EksContainerResourceRequirements.ReadOnly
    ]
    def getImage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("image", image)
    def getCommand: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("command", command)
    def getArgs: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("args", args)
    def getEnv: ZIO[Any, AwsError, List[
      zio.aws.batch.model.EksContainerEnvironmentVariable.ReadOnly
    ]] = AwsError.unwrapOptionField("env", env)
    def getResources: ZIO[
      Any,
      AwsError,
      zio.aws.batch.model.EksContainerResourceRequirements.ReadOnly
    ] = AwsError.unwrapOptionField("resources", resources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.EksContainerOverride
  ) extends zio.aws.batch.model.EksContainerOverride.ReadOnly {
    override val image: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.image())
      .map(value => value: String)
    override val command: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.command())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val args: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.args())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val env: Optional[
      List[zio.aws.batch.model.EksContainerEnvironmentVariable.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.env())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.batch.model.EksContainerEnvironmentVariable.wrap(item)
        }.toList
      )
    override val resources: Optional[
      zio.aws.batch.model.EksContainerResourceRequirements.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resources())
      .map(value =>
        zio.aws.batch.model.EksContainerResourceRequirements.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.EksContainerOverride
  ): zio.aws.batch.model.EksContainerOverride.ReadOnly = new Wrapper(impl)
}
