package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EksPropertiesDetail(
    podProperties: Optional[zio.aws.batch.model.EksPodPropertiesDetail] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.EksPropertiesDetail = {
    import EksPropertiesDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.EksPropertiesDetail
      .builder()
      .optionallyWith(podProperties.map(value => value.buildAwsValue()))(
        _.podProperties
      )
      .build()
  }
  def asReadOnly: zio.aws.batch.model.EksPropertiesDetail.ReadOnly =
    zio.aws.batch.model.EksPropertiesDetail.wrap(buildAwsValue())
}
object EksPropertiesDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.EksPropertiesDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.EksPropertiesDetail =
      zio.aws.batch.model
        .EksPropertiesDetail(podProperties.map(value => value.asEditable))
    def podProperties
        : Optional[zio.aws.batch.model.EksPodPropertiesDetail.ReadOnly]
    def getPodProperties: ZIO[
      Any,
      AwsError,
      zio.aws.batch.model.EksPodPropertiesDetail.ReadOnly
    ] = AwsError.unwrapOptionField("podProperties", podProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.EksPropertiesDetail
  ) extends zio.aws.batch.model.EksPropertiesDetail.ReadOnly {
    override val podProperties
        : Optional[zio.aws.batch.model.EksPodPropertiesDetail.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.podProperties())
        .map(value => zio.aws.batch.model.EksPodPropertiesDetail.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.EksPropertiesDetail
  ): zio.aws.batch.model.EksPropertiesDetail.ReadOnly = new Wrapper(impl)
}
