package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EksPropertiesOverride(
    podProperties: Optional[zio.aws.batch.model.EksPodPropertiesOverride] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.EksPropertiesOverride = {
    import EksPropertiesOverride.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.EksPropertiesOverride
      .builder()
      .optionallyWith(podProperties.map(value => value.buildAwsValue()))(
        _.podProperties
      )
      .build()
  }
  def asReadOnly: zio.aws.batch.model.EksPropertiesOverride.ReadOnly =
    zio.aws.batch.model.EksPropertiesOverride.wrap(buildAwsValue())
}
object EksPropertiesOverride {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.EksPropertiesOverride
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.EksPropertiesOverride =
      zio.aws.batch.model
        .EksPropertiesOverride(podProperties.map(value => value.asEditable))
    def podProperties
        : Optional[zio.aws.batch.model.EksPodPropertiesOverride.ReadOnly]
    def getPodProperties: ZIO[
      Any,
      AwsError,
      zio.aws.batch.model.EksPodPropertiesOverride.ReadOnly
    ] = AwsError.unwrapOptionField("podProperties", podProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.EksPropertiesOverride
  ) extends zio.aws.batch.model.EksPropertiesOverride.ReadOnly {
    override val podProperties
        : Optional[zio.aws.batch.model.EksPodPropertiesOverride.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.podProperties())
        .map(value => zio.aws.batch.model.EksPodPropertiesOverride.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.EksPropertiesOverride
  ): zio.aws.batch.model.EksPropertiesOverride.ReadOnly = new Wrapper(impl)
}
