package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EksVolume(
    name: String,
    hostPath: Optional[zio.aws.batch.model.EksHostPath] = Optional.Absent,
    emptyDir: Optional[zio.aws.batch.model.EksEmptyDir] = Optional.Absent,
    secret: Optional[zio.aws.batch.model.EksSecret] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.batch.model.EksVolume = {
    import EksVolume.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.EksVolume
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(hostPath.map(value => value.buildAwsValue()))(_.hostPath)
      .optionallyWith(emptyDir.map(value => value.buildAwsValue()))(_.emptyDir)
      .optionallyWith(secret.map(value => value.buildAwsValue()))(_.secret)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.EksVolume.ReadOnly =
    zio.aws.batch.model.EksVolume.wrap(buildAwsValue())
}
object EksVolume {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.batch.model.EksVolume] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.EksVolume =
      zio.aws.batch.model.EksVolume(
        name,
        hostPath.map(value => value.asEditable),
        emptyDir.map(value => value.asEditable),
        secret.map(value => value.asEditable)
      )
    def name: String
    def hostPath: Optional[zio.aws.batch.model.EksHostPath.ReadOnly]
    def emptyDir: Optional[zio.aws.batch.model.EksEmptyDir.ReadOnly]
    def secret: Optional[zio.aws.batch.model.EksSecret.ReadOnly]
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getHostPath
        : ZIO[Any, AwsError, zio.aws.batch.model.EksHostPath.ReadOnly] =
      AwsError.unwrapOptionField("hostPath", hostPath)
    def getEmptyDir
        : ZIO[Any, AwsError, zio.aws.batch.model.EksEmptyDir.ReadOnly] =
      AwsError.unwrapOptionField("emptyDir", emptyDir)
    def getSecret: ZIO[Any, AwsError, zio.aws.batch.model.EksSecret.ReadOnly] =
      AwsError.unwrapOptionField("secret", secret)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.EksVolume
  ) extends zio.aws.batch.model.EksVolume.ReadOnly {
    override val name: String = impl.name(): String
    override val hostPath: Optional[zio.aws.batch.model.EksHostPath.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hostPath())
        .map(value => zio.aws.batch.model.EksHostPath.wrap(value))
    override val emptyDir: Optional[zio.aws.batch.model.EksEmptyDir.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.emptyDir())
        .map(value => zio.aws.batch.model.EksEmptyDir.wrap(value))
    override val secret: Optional[zio.aws.batch.model.EksSecret.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secret())
        .map(value => zio.aws.batch.model.EksSecret.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.EksVolume
  ): zio.aws.batch.model.EksVolume.ReadOnly = new Wrapper(impl)
}
