package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LaunchTemplateSpecification(
    launchTemplateId: Optional[String] = Optional.Absent,
    launchTemplateName: Optional[String] = Optional.Absent,
    version: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.LaunchTemplateSpecification = {
    import LaunchTemplateSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.LaunchTemplateSpecification
      .builder()
      .optionallyWith(launchTemplateId.map(value => value: java.lang.String))(
        _.launchTemplateId
      )
      .optionallyWith(launchTemplateName.map(value => value: java.lang.String))(
        _.launchTemplateName
      )
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.LaunchTemplateSpecification.ReadOnly =
    zio.aws.batch.model.LaunchTemplateSpecification.wrap(buildAwsValue())
}
object LaunchTemplateSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.LaunchTemplateSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.LaunchTemplateSpecification =
      zio.aws.batch.model.LaunchTemplateSpecification(
        launchTemplateId.map(value => value),
        launchTemplateName.map(value => value),
        version.map(value => value)
      )
    def launchTemplateId: Optional[String]
    def launchTemplateName: Optional[String]
    def version: Optional[String]
    def getLaunchTemplateId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("launchTemplateId", launchTemplateId)
    def getLaunchTemplateName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("launchTemplateName", launchTemplateName)
    def getVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.LaunchTemplateSpecification
  ) extends zio.aws.batch.model.LaunchTemplateSpecification.ReadOnly {
    override val launchTemplateId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.launchTemplateId())
      .map(value => value: String)
    override val launchTemplateName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.launchTemplateName())
      .map(value => value: String)
    override val version: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.LaunchTemplateSpecification
  ): zio.aws.batch.model.LaunchTemplateSpecification.ReadOnly = new Wrapper(
    impl
  )
}
