package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AttemptContainerDetail(
    containerInstanceArn: Optional[String] = Optional.Absent,
    taskArn: Optional[String] = Optional.Absent,
    exitCode: Optional[Integer] = Optional.Absent,
    reason: Optional[String] = Optional.Absent,
    logStreamName: Optional[String] = Optional.Absent,
    networkInterfaces: Optional[
      Iterable[zio.aws.batch.model.NetworkInterface]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.AttemptContainerDetail = {
    import AttemptContainerDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.AttemptContainerDetail
      .builder()
      .optionallyWith(
        containerInstanceArn.map(value => value: java.lang.String)
      )(_.containerInstanceArn)
      .optionallyWith(taskArn.map(value => value: java.lang.String))(_.taskArn)
      .optionallyWith(exitCode.map(value => value: java.lang.Integer))(
        _.exitCode
      )
      .optionallyWith(reason.map(value => value: java.lang.String))(_.reason)
      .optionallyWith(logStreamName.map(value => value: java.lang.String))(
        _.logStreamName
      )
      .optionallyWith(
        networkInterfaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkInterfaces)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.AttemptContainerDetail.ReadOnly =
    zio.aws.batch.model.AttemptContainerDetail.wrap(buildAwsValue())
}
object AttemptContainerDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.AttemptContainerDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.AttemptContainerDetail =
      zio.aws.batch.model.AttemptContainerDetail(
        containerInstanceArn.map(value => value),
        taskArn.map(value => value),
        exitCode.map(value => value),
        reason.map(value => value),
        logStreamName.map(value => value),
        networkInterfaces.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def containerInstanceArn: Optional[String]
    def taskArn: Optional[String]
    def exitCode: Optional[Integer]
    def reason: Optional[String]
    def logStreamName: Optional[String]
    def networkInterfaces
        : Optional[List[zio.aws.batch.model.NetworkInterface.ReadOnly]]
    def getContainerInstanceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("containerInstanceArn", containerInstanceArn)
    def getTaskArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("taskArn", taskArn)
    def getExitCode: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("exitCode", exitCode)
    def getReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reason", reason)
    def getLogStreamName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("logStreamName", logStreamName)
    def getNetworkInterfaces: ZIO[Any, AwsError, List[
      zio.aws.batch.model.NetworkInterface.ReadOnly
    ]] = AwsError.unwrapOptionField("networkInterfaces", networkInterfaces)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.AttemptContainerDetail
  ) extends zio.aws.batch.model.AttemptContainerDetail.ReadOnly {
    override val containerInstanceArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.containerInstanceArn())
      .map(value => value: String)
    override val taskArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.taskArn())
      .map(value => value: String)
    override val exitCode: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.exitCode())
      .map(value => value: Integer)
    override val reason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value => value: String)
    override val logStreamName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.logStreamName())
      .map(value => value: String)
    override val networkInterfaces
        : Optional[List[zio.aws.batch.model.NetworkInterface.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterfaces())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.batch.model.NetworkInterface.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.AttemptContainerDetail
  ): zio.aws.batch.model.AttemptContainerDetail.ReadOnly = new Wrapper(impl)
}
