package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CancelJobRequest(jobId: String, reason: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.CancelJobRequest = {
    import CancelJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.CancelJobRequest
      .builder()
      .jobId(jobId: java.lang.String)
      .reason(reason: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.CancelJobRequest.ReadOnly =
    zio.aws.batch.model.CancelJobRequest.wrap(buildAwsValue())
}
object CancelJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.CancelJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.CancelJobRequest =
      zio.aws.batch.model.CancelJobRequest(jobId, reason)
    def jobId: String
    def reason: String
    def getJobId: ZIO[Any, Nothing, String] = ZIO.succeed(jobId)
    def getReason: ZIO[Any, Nothing, String] = ZIO.succeed(reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.CancelJobRequest
  ) extends zio.aws.batch.model.CancelJobRequest.ReadOnly {
    override val jobId: String = impl.jobId(): String
    override val reason: String = impl.reason(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.CancelJobRequest
  ): zio.aws.batch.model.CancelJobRequest.ReadOnly = new Wrapper(impl)
}
