package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ComputeResourceUpdate(
    minvCpus: Optional[Integer] = Optional.Absent,
    maxvCpus: Optional[Integer] = Optional.Absent,
    desiredvCpus: Optional[Integer] = Optional.Absent,
    subnets: Optional[Iterable[String]] = Optional.Absent,
    securityGroupIds: Optional[Iterable[String]] = Optional.Absent,
    allocationStrategy: Optional[
      zio.aws.batch.model.CRUpdateAllocationStrategy
    ] = Optional.Absent,
    instanceTypes: Optional[Iterable[String]] = Optional.Absent,
    ec2KeyPair: Optional[String] = Optional.Absent,
    instanceRole: Optional[String] = Optional.Absent,
    tags: Optional[Map[String, String]] = Optional.Absent,
    placementGroup: Optional[String] = Optional.Absent,
    bidPercentage: Optional[Integer] = Optional.Absent,
    launchTemplate: Optional[zio.aws.batch.model.LaunchTemplateSpecification] =
      Optional.Absent,
    ec2Configuration: Optional[Iterable[zio.aws.batch.model.Ec2Configuration]] =
      Optional.Absent,
    updateToLatestImageVersion: Optional[Boolean] = Optional.Absent,
    `type`: Optional[zio.aws.batch.model.CRType] = Optional.Absent,
    imageId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.ComputeResourceUpdate = {
    import ComputeResourceUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.ComputeResourceUpdate
      .builder()
      .optionallyWith(minvCpus.map(value => value: java.lang.Integer))(
        _.minvCpus
      )
      .optionallyWith(maxvCpus.map(value => value: java.lang.Integer))(
        _.maxvCpus
      )
      .optionallyWith(desiredvCpus.map(value => value: java.lang.Integer))(
        _.desiredvCpus
      )
      .optionallyWith(
        subnets.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subnets)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(allocationStrategy.map(value => value.unwrap))(
        _.allocationStrategy
      )
      .optionallyWith(
        instanceTypes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.instanceTypes)
      .optionallyWith(ec2KeyPair.map(value => value: java.lang.String))(
        _.ec2KeyPair
      )
      .optionallyWith(instanceRole.map(value => value: java.lang.String))(
        _.instanceRole
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(placementGroup.map(value => value: java.lang.String))(
        _.placementGroup
      )
      .optionallyWith(bidPercentage.map(value => value: java.lang.Integer))(
        _.bidPercentage
      )
      .optionallyWith(launchTemplate.map(value => value.buildAwsValue()))(
        _.launchTemplate
      )
      .optionallyWith(
        ec2Configuration.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ec2Configuration)
      .optionallyWith(
        updateToLatestImageVersion.map(value => value: java.lang.Boolean)
      )(_.updateToLatestImageVersion)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(imageId.map(value => value: java.lang.String))(_.imageId)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.ComputeResourceUpdate.ReadOnly =
    zio.aws.batch.model.ComputeResourceUpdate.wrap(buildAwsValue())
}
object ComputeResourceUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.ComputeResourceUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.ComputeResourceUpdate =
      zio.aws.batch.model.ComputeResourceUpdate(
        minvCpus.map(value => value),
        maxvCpus.map(value => value),
        desiredvCpus.map(value => value),
        subnets.map(value => value),
        securityGroupIds.map(value => value),
        allocationStrategy.map(value => value),
        instanceTypes.map(value => value),
        ec2KeyPair.map(value => value),
        instanceRole.map(value => value),
        tags.map(value => value),
        placementGroup.map(value => value),
        bidPercentage.map(value => value),
        launchTemplate.map(value => value.asEditable),
        ec2Configuration.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        updateToLatestImageVersion.map(value => value),
        `type`.map(value => value),
        imageId.map(value => value)
      )
    def minvCpus: Optional[Integer]
    def maxvCpus: Optional[Integer]
    def desiredvCpus: Optional[Integer]
    def subnets: Optional[List[String]]
    def securityGroupIds: Optional[List[String]]
    def allocationStrategy
        : Optional[zio.aws.batch.model.CRUpdateAllocationStrategy]
    def instanceTypes: Optional[List[String]]
    def ec2KeyPair: Optional[String]
    def instanceRole: Optional[String]
    def tags: Optional[Map[String, String]]
    def placementGroup: Optional[String]
    def bidPercentage: Optional[Integer]
    def launchTemplate
        : Optional[zio.aws.batch.model.LaunchTemplateSpecification.ReadOnly]
    def ec2Configuration
        : Optional[List[zio.aws.batch.model.Ec2Configuration.ReadOnly]]
    def updateToLatestImageVersion: Optional[Boolean]
    def `type`: Optional[zio.aws.batch.model.CRType]
    def imageId: Optional[String]
    def getMinvCpus: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("minvCpus", minvCpus)
    def getMaxvCpus: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxvCpus", maxvCpus)
    def getDesiredvCpus: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("desiredvCpus", desiredvCpus)
    def getSubnets: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("subnets", subnets)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getAllocationStrategy
        : ZIO[Any, AwsError, zio.aws.batch.model.CRUpdateAllocationStrategy] =
      AwsError.unwrapOptionField("allocationStrategy", allocationStrategy)
    def getInstanceTypes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("instanceTypes", instanceTypes)
    def getEc2KeyPair: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ec2KeyPair", ec2KeyPair)
    def getInstanceRole: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceRole", instanceRole)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
    def getPlacementGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("placementGroup", placementGroup)
    def getBidPercentage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("bidPercentage", bidPercentage)
    def getLaunchTemplate: ZIO[
      Any,
      AwsError,
      zio.aws.batch.model.LaunchTemplateSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("launchTemplate", launchTemplate)
    def getEc2Configuration: ZIO[Any, AwsError, List[
      zio.aws.batch.model.Ec2Configuration.ReadOnly
    ]] = AwsError.unwrapOptionField("ec2Configuration", ec2Configuration)
    def getUpdateToLatestImageVersion: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "updateToLatestImageVersion",
        updateToLatestImageVersion
      )
    def getType: ZIO[Any, AwsError, zio.aws.batch.model.CRType] =
      AwsError.unwrapOptionField("type", `type`)
    def getImageId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageId", imageId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.ComputeResourceUpdate
  ) extends zio.aws.batch.model.ComputeResourceUpdate.ReadOnly {
    override val minvCpus: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.minvCpus())
      .map(value => value: Integer)
    override val maxvCpus: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxvCpus())
      .map(value => value: Integer)
    override val desiredvCpus: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.desiredvCpus())
      .map(value => value: Integer)
    override val subnets: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnets())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val securityGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val allocationStrategy
        : Optional[zio.aws.batch.model.CRUpdateAllocationStrategy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allocationStrategy())
        .map(value =>
          zio.aws.batch.model.CRUpdateAllocationStrategy.wrap(value)
        )
    override val instanceTypes: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceTypes())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val ec2KeyPair: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ec2KeyPair())
      .map(value => value: String)
    override val instanceRole: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceRole())
      .map(value => value: String)
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val placementGroup: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.placementGroup())
      .map(value => value: String)
    override val bidPercentage: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.bidPercentage())
      .map(value => value: Integer)
    override val launchTemplate
        : Optional[zio.aws.batch.model.LaunchTemplateSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchTemplate())
        .map(value =>
          zio.aws.batch.model.LaunchTemplateSpecification.wrap(value)
        )
    override val ec2Configuration
        : Optional[List[zio.aws.batch.model.Ec2Configuration.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ec2Configuration())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.batch.model.Ec2Configuration.wrap(item)
          }.toList
        )
    override val updateToLatestImageVersion: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updateToLatestImageVersion())
        .map(value => value: Boolean)
    override val `type`: Optional[zio.aws.batch.model.CRType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.batch.model.CRType.wrap(value))
    override val imageId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.imageId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.ComputeResourceUpdate
  ): zio.aws.batch.model.ComputeResourceUpdate.ReadOnly = new Wrapper(impl)
}
