package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ContainerOverrides(
    vcpus: Optional[Integer] = Optional.Absent,
    memory: Optional[Integer] = Optional.Absent,
    command: Optional[Iterable[String]] = Optional.Absent,
    instanceType: Optional[String] = Optional.Absent,
    environment: Optional[Iterable[zio.aws.batch.model.KeyValuePair]] =
      Optional.Absent,
    resourceRequirements: Optional[
      Iterable[zio.aws.batch.model.ResourceRequirement]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.ContainerOverrides = {
    import ContainerOverrides.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.ContainerOverrides
      .builder()
      .optionallyWith(vcpus.map(value => value: java.lang.Integer))(_.vcpus)
      .optionallyWith(memory.map(value => value: java.lang.Integer))(_.memory)
      .optionallyWith(
        command.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.command)
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(
        environment.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.environment)
      .optionallyWith(
        resourceRequirements.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceRequirements)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.ContainerOverrides.ReadOnly =
    zio.aws.batch.model.ContainerOverrides.wrap(buildAwsValue())
}
object ContainerOverrides {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.ContainerOverrides
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.ContainerOverrides =
      zio.aws.batch.model.ContainerOverrides(
        vcpus.map(value => value),
        memory.map(value => value),
        command.map(value => value),
        instanceType.map(value => value),
        environment.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceRequirements.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def vcpus: Optional[Integer]
    def memory: Optional[Integer]
    def command: Optional[List[String]]
    def instanceType: Optional[String]
    def environment: Optional[List[zio.aws.batch.model.KeyValuePair.ReadOnly]]
    def resourceRequirements
        : Optional[List[zio.aws.batch.model.ResourceRequirement.ReadOnly]]
    def getVcpus: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("vcpus", vcpus)
    def getMemory: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("memory", memory)
    def getCommand: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("command", command)
    def getInstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getEnvironment
        : ZIO[Any, AwsError, List[zio.aws.batch.model.KeyValuePair.ReadOnly]] =
      AwsError.unwrapOptionField("environment", environment)
    def getResourceRequirements: ZIO[Any, AwsError, List[
      zio.aws.batch.model.ResourceRequirement.ReadOnly
    ]] =
      AwsError.unwrapOptionField("resourceRequirements", resourceRequirements)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.ContainerOverrides
  ) extends zio.aws.batch.model.ContainerOverrides.ReadOnly {
    override val vcpus: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.vcpus())
      .map(value => value: Integer)
    override val memory: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.memory())
      .map(value => value: Integer)
    override val command: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.command())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val instanceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceType())
      .map(value => value: String)
    override val environment
        : Optional[List[zio.aws.batch.model.KeyValuePair.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environment())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.batch.model.KeyValuePair.wrap(item)
          }.toList
        )
    override val resourceRequirements
        : Optional[List[zio.aws.batch.model.ResourceRequirement.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceRequirements())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.batch.model.ResourceRequirement.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.ContainerOverrides
  ): zio.aws.batch.model.ContainerOverrides.ReadOnly = new Wrapper(impl)
}
