package zio.aws.batch.model
import zio.aws.batch.model.primitives.{TagValue, TagKey, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateJobQueueRequest(
    jobQueueName: String,
    state: Optional[zio.aws.batch.model.JQState] = Optional.Absent,
    schedulingPolicyArn: Optional[String] = Optional.Absent,
    priority: Integer,
    computeEnvironmentOrder: Iterable[
      zio.aws.batch.model.ComputeEnvironmentOrder
    ],
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.CreateJobQueueRequest = {
    import CreateJobQueueRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.CreateJobQueueRequest
      .builder()
      .jobQueueName(jobQueueName: java.lang.String)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        schedulingPolicyArn.map(value => value: java.lang.String)
      )(_.schedulingPolicyArn)
      .priority(priority: java.lang.Integer)
      .computeEnvironmentOrder(computeEnvironmentOrder.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.CreateJobQueueRequest.ReadOnly =
    zio.aws.batch.model.CreateJobQueueRequest.wrap(buildAwsValue())
}
object CreateJobQueueRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.CreateJobQueueRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.CreateJobQueueRequest =
      zio.aws.batch.model.CreateJobQueueRequest(
        jobQueueName,
        state.map(value => value),
        schedulingPolicyArn.map(value => value),
        priority,
        computeEnvironmentOrder.map { item =>
          item.asEditable
        },
        tags.map(value => value)
      )
    def jobQueueName: String
    def state: Optional[zio.aws.batch.model.JQState]
    def schedulingPolicyArn: Optional[String]
    def priority: Integer
    def computeEnvironmentOrder
        : List[zio.aws.batch.model.ComputeEnvironmentOrder.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def getJobQueueName: ZIO[Any, Nothing, String] = ZIO.succeed(jobQueueName)
    def getState: ZIO[Any, AwsError, zio.aws.batch.model.JQState] =
      AwsError.unwrapOptionField("state", state)
    def getSchedulingPolicyArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("schedulingPolicyArn", schedulingPolicyArn)
    def getPriority: ZIO[Any, Nothing, Integer] = ZIO.succeed(priority)
    def getComputeEnvironmentOrder: ZIO[Any, Nothing, List[
      zio.aws.batch.model.ComputeEnvironmentOrder.ReadOnly
    ]] = ZIO.succeed(computeEnvironmentOrder)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.CreateJobQueueRequest
  ) extends zio.aws.batch.model.CreateJobQueueRequest.ReadOnly {
    override val jobQueueName: String = impl.jobQueueName(): String
    override val state: Optional[zio.aws.batch.model.JQState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.batch.model.JQState.wrap(value))
    override val schedulingPolicyArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.schedulingPolicyArn())
      .map(value => value: String)
    override val priority: Integer = impl.priority(): Integer
    override val computeEnvironmentOrder
        : List[zio.aws.batch.model.ComputeEnvironmentOrder.ReadOnly] = impl
      .computeEnvironmentOrder()
      .asScala
      .map { item =>
        zio.aws.batch.model.ComputeEnvironmentOrder.wrap(item)
      }
      .toList
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.batch.model.primitives
              .TagKey(key) -> zio.aws.batch.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.CreateJobQueueRequest
  ): zio.aws.batch.model.CreateJobQueueRequest.ReadOnly = new Wrapper(impl)
}
