package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateJobQueueResponse(
    jobQueueName: String,
    jobQueueArn: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.CreateJobQueueResponse = {
    import CreateJobQueueResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.CreateJobQueueResponse
      .builder()
      .jobQueueName(jobQueueName: java.lang.String)
      .jobQueueArn(jobQueueArn: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.CreateJobQueueResponse.ReadOnly =
    zio.aws.batch.model.CreateJobQueueResponse.wrap(buildAwsValue())
}
object CreateJobQueueResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.CreateJobQueueResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.CreateJobQueueResponse =
      zio.aws.batch.model.CreateJobQueueResponse(jobQueueName, jobQueueArn)
    def jobQueueName: String
    def jobQueueArn: String
    def getJobQueueName: ZIO[Any, Nothing, String] = ZIO.succeed(jobQueueName)
    def getJobQueueArn: ZIO[Any, Nothing, String] = ZIO.succeed(jobQueueArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.CreateJobQueueResponse
  ) extends zio.aws.batch.model.CreateJobQueueResponse.ReadOnly {
    override val jobQueueName: String = impl.jobQueueName(): String
    override val jobQueueArn: String = impl.jobQueueArn(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.CreateJobQueueResponse
  ): zio.aws.batch.model.CreateJobQueueResponse.ReadOnly = new Wrapper(impl)
}
