package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateSchedulingPolicyResponse(name: String, arn: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.CreateSchedulingPolicyResponse = {
    import CreateSchedulingPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.CreateSchedulingPolicyResponse
      .builder()
      .name(name: java.lang.String)
      .arn(arn: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.CreateSchedulingPolicyResponse.ReadOnly =
    zio.aws.batch.model.CreateSchedulingPolicyResponse.wrap(buildAwsValue())
}
object CreateSchedulingPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.CreateSchedulingPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.CreateSchedulingPolicyResponse =
      zio.aws.batch.model.CreateSchedulingPolicyResponse(name, arn)
    def name: String
    def arn: String
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getArn: ZIO[Any, Nothing, String] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.CreateSchedulingPolicyResponse
  ) extends zio.aws.batch.model.CreateSchedulingPolicyResponse.ReadOnly {
    override val name: String = impl.name(): String
    override val arn: String = impl.arn(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.CreateSchedulingPolicyResponse
  ): zio.aws.batch.model.CreateSchedulingPolicyResponse.ReadOnly = new Wrapper(
    impl
  )
}
