package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteComputeEnvironmentRequest(computeEnvironment: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.DeleteComputeEnvironmentRequest = {
    import DeleteComputeEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.DeleteComputeEnvironmentRequest
      .builder()
      .computeEnvironment(computeEnvironment: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.DeleteComputeEnvironmentRequest.ReadOnly =
    zio.aws.batch.model.DeleteComputeEnvironmentRequest.wrap(buildAwsValue())
}
object DeleteComputeEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.DeleteComputeEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.DeleteComputeEnvironmentRequest =
      zio.aws.batch.model.DeleteComputeEnvironmentRequest(computeEnvironment)
    def computeEnvironment: String
    def getComputeEnvironment: ZIO[Any, Nothing, String] =
      ZIO.succeed(computeEnvironment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.DeleteComputeEnvironmentRequest
  ) extends zio.aws.batch.model.DeleteComputeEnvironmentRequest.ReadOnly {
    override val computeEnvironment: String = impl.computeEnvironment(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.DeleteComputeEnvironmentRequest
  ): zio.aws.batch.model.DeleteComputeEnvironmentRequest.ReadOnly = new Wrapper(
    impl
  )
}
