package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteJobQueueRequest(jobQueue: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.DeleteJobQueueRequest = {
    import DeleteJobQueueRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.DeleteJobQueueRequest
      .builder()
      .jobQueue(jobQueue: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.DeleteJobQueueRequest.ReadOnly =
    zio.aws.batch.model.DeleteJobQueueRequest.wrap(buildAwsValue())
}
object DeleteJobQueueRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.DeleteJobQueueRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.DeleteJobQueueRequest =
      zio.aws.batch.model.DeleteJobQueueRequest(jobQueue)
    def jobQueue: String
    def getJobQueue: ZIO[Any, Nothing, String] = ZIO.succeed(jobQueue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.DeleteJobQueueRequest
  ) extends zio.aws.batch.model.DeleteJobQueueRequest.ReadOnly {
    override val jobQueue: String = impl.jobQueue(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.DeleteJobQueueRequest
  ): zio.aws.batch.model.DeleteJobQueueRequest.ReadOnly = new Wrapper(impl)
}
