package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeregisterJobDefinitionRequest(jobDefinition: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.DeregisterJobDefinitionRequest = {
    import DeregisterJobDefinitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.DeregisterJobDefinitionRequest
      .builder()
      .jobDefinition(jobDefinition: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.DeregisterJobDefinitionRequest.ReadOnly =
    zio.aws.batch.model.DeregisterJobDefinitionRequest.wrap(buildAwsValue())
}
object DeregisterJobDefinitionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.DeregisterJobDefinitionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.DeregisterJobDefinitionRequest =
      zio.aws.batch.model.DeregisterJobDefinitionRequest(jobDefinition)
    def jobDefinition: String
    def getJobDefinition: ZIO[Any, Nothing, String] = ZIO.succeed(jobDefinition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.DeregisterJobDefinitionRequest
  ) extends zio.aws.batch.model.DeregisterJobDefinitionRequest.ReadOnly {
    override val jobDefinition: String = impl.jobDefinition(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.DeregisterJobDefinitionRequest
  ): zio.aws.batch.model.DeregisterJobDefinitionRequest.ReadOnly = new Wrapper(
    impl
  )
}
